/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.RedisCommandExecutionException;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.output.StreamingOutput;
import com.lambdaworks.redis.protocol.CommandWrapper;
import com.lambdaworks.redis.protocol.RedisCommand;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import rx.Observable;
import rx.Subscriber;

public class ReactiveCommandDispatcher<K, V, T>
implements Observable.OnSubscribe<T> {
    private Supplier<? extends RedisCommand<K, V, T>> commandSupplier;
    private volatile RedisCommand<K, V, T> command;
    private StatefulConnection<K, V> connection;
    private boolean dissolve;

    public ReactiveCommandDispatcher(RedisCommand<K, V, T> staticCommand, StatefulConnection<K, V> connection, boolean dissolve) {
        this(() -> staticCommand, connection, dissolve);
    }

    public ReactiveCommandDispatcher(Supplier<RedisCommand<K, V, T>> commandSupplier, StatefulConnection<K, V> connection, boolean dissolve) {
        LettuceAssert.notNull(commandSupplier, "CommandSupplier must not be null");
        LettuceAssert.notNull(connection, "StatefulConnection must not be null");
        this.commandSupplier = commandSupplier;
        this.connection = connection;
        this.dissolve = dissolve;
        this.command = commandSupplier.get();
    }

    public void call(Subscriber<? super T> subscriber) {
        RedisCommand<K, V, T> command = this.command;
        if (command == null) {
            command = this.commandSupplier.get();
        }
        if (command.getOutput() instanceof StreamingOutput) {
            StreamingOutput streamingOutput = (StreamingOutput)((Object)command.getOutput());
            if (this.connection instanceof StatefulRedisConnection && ((StatefulRedisConnection)this.connection).isMulti()) {
                streamingOutput.setSubscriber(new DelegatingWrapper(Arrays.asList(new ObservableSubscriberWrapper<T>(subscriber), streamingOutput.getSubscriber())));
            } else {
                streamingOutput.setSubscriber(new ObservableSubscriberWrapper<T>(subscriber));
            }
        }
        this.connection.dispatch(new ObservableCommand<K, V, T>(command, subscriber, this.dissolve));
        this.command = null;
    }

    static class DelegatingWrapper<T>
    implements StreamingOutput.Subscriber<T> {
        private Collection<StreamingOutput.Subscriber<T>> subscribers;

        public DelegatingWrapper(Collection<StreamingOutput.Subscriber<T>> subscribers) {
            this.subscribers = subscribers;
        }

        @Override
        public void onNext(T t) {
            for (StreamingOutput.Subscriber<T> subscriber : this.subscribers) {
                subscriber.onNext(t);
            }
        }
    }

    static class ObservableSubscriberWrapper<T>
    implements StreamingOutput.Subscriber<T> {
        private Subscriber<? super T> subscriber;

        public ObservableSubscriberWrapper(Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void onNext(T t) {
            if (this.subscriber.isUnsubscribed()) {
                return;
            }
            this.subscriber.onNext(t);
        }
    }

    private static class ObservableCommand<K, V, T>
    extends CommandWrapper<K, V, T> {
        private final Subscriber<? super T> subscriber;
        private final boolean dissolve;
        private boolean completed = false;

        public ObservableCommand(RedisCommand<K, V, T> command, Subscriber<? super T> subscriber, boolean dissolve) {
            super(command);
            this.subscriber = subscriber;
            this.dissolve = dissolve;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() {
            if (this.completed || this.subscriber.isUnsubscribed()) {
                return;
            }
            try {
                super.complete();
                if (this.getOutput() != null) {
                    Object result = this.getOutput().get();
                    if (!(this.getOutput() instanceof StreamingOutput) && result != null) {
                        if (this.dissolve && result instanceof Collection) {
                            Collection collection = (Collection)result;
                            for (Object t : collection) {
                                this.subscriber.onNext(t);
                            }
                        } else {
                            this.subscriber.onNext(result);
                        }
                    }
                    if (this.getOutput().hasError()) {
                        this.subscriber.onError((Throwable)new RedisCommandExecutionException(this.getOutput().getError()));
                        this.completed = true;
                        return;
                    }
                }
                try {
                    this.subscriber.onCompleted();
                }
                catch (Exception e) {
                    this.completeExceptionally(e);
                }
            }
            finally {
                this.completed = true;
            }
        }

        @Override
        public void cancel() {
            if (this.completed || this.subscriber.isUnsubscribed()) {
                return;
            }
            super.cancel();
            this.subscriber.onCompleted();
            this.completed = true;
        }

        @Override
        public boolean completeExceptionally(Throwable throwable) {
            if (this.completed || this.subscriber.isUnsubscribed()) {
                return false;
            }
            boolean b = super.completeExceptionally(throwable);
            this.subscriber.onError(throwable);
            this.completed = true;
            return b;
        }
    }
}

