/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.subjects;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.observers.SerializedObserver;
import com.lambdaworks.rx.subjects.Subject;

public class SerializedSubject<T, R>
extends Subject<T, R> {
    private final SerializedObserver<T> observer;
    private final Subject<T, R> actual;

    public SerializedSubject(final Subject<T, R> actual) {
        super(new Observable.OnSubscribe<R>(){

            @Override
            public void call(Subscriber<? super R> child) {
                actual.unsafeSubscribe(child);
            }
        });
        this.actual = actual;
        this.observer = new SerializedObserver(actual);
    }

    @Override
    public void onCompleted() {
        this.observer.onCompleted();
    }

    @Override
    public void onError(Throwable e) {
        this.observer.onError(e);
    }

    @Override
    public void onNext(T t) {
        this.observer.onNext(t);
    }

    @Override
    public boolean hasObservers() {
        return this.actual.hasObservers();
    }
}

