/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.subjects;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.annotations.Beta;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.functions.Action1;
import com.lambdaworks.rx.internal.operators.NotificationLite;
import com.lambdaworks.rx.subjects.Subject;
import com.lambdaworks.rx.subjects.SubjectSubscriptionManager;
import java.util.ArrayList;

public final class PublishSubject<T>
extends Subject<T, T> {
    final SubjectSubscriptionManager<T> state;
    private final NotificationLite<T> nl = NotificationLite.instance();

    public static <T> PublishSubject<T> create() {
        final SubjectSubscriptionManager state = new SubjectSubscriptionManager();
        state.onTerminated = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                o.emitFirst(state.getLatest(), state.nl);
            }
        };
        return new PublishSubject(state, state);
    }

    protected PublishSubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> state) {
        super(onSubscribe);
        this.state = state;
    }

    @Override
    public void onCompleted() {
        if (this.state.active) {
            Object n = this.nl.completed();
            for (SubjectSubscriptionManager.SubjectObserver bo : this.state.terminate(n)) {
                bo.emitNext(n, this.state.nl);
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        if (this.state.active) {
            Object n = this.nl.error(e);
            ArrayList<Throwable> errors = null;
            for (SubjectSubscriptionManager.SubjectObserver bo : this.state.terminate(n)) {
                try {
                    bo.emitNext(n, this.state.nl);
                }
                catch (Throwable e2) {
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(e2);
                }
            }
            Exceptions.throwIfAny(errors);
        }
    }

    @Override
    public void onNext(T v) {
        for (SubjectSubscriptionManager.SubjectObserver<T> bo : this.state.observers()) {
            bo.onNext(v);
        }
    }

    @Override
    public boolean hasObservers() {
        return this.state.observers().length > 0;
    }

    @Beta
    public boolean hasThrowable() {
        Object o = this.state.getLatest();
        return this.nl.isError(o);
    }

    @Beta
    public boolean hasCompleted() {
        Object o = this.state.getLatest();
        return o != null && !this.nl.isError(o);
    }

    @Beta
    public Throwable getThrowable() {
        Object o = this.state.getLatest();
        if (this.nl.isError(o)) {
            return this.nl.getError(o);
        }
        return null;
    }
}

