/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.singles;

import com.lambdaworks.rx.Single;
import com.lambdaworks.rx.SingleSubscriber;
import com.lambdaworks.rx.Subscription;
import com.lambdaworks.rx.annotations.Experimental;
import com.lambdaworks.rx.internal.operators.BlockingOperatorToFuture;
import com.lambdaworks.rx.internal.util.BlockingUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

@Experimental
public class BlockingSingle<T> {
    private final Single<? extends T> single;

    private BlockingSingle(Single<? extends T> single) {
        this.single = single;
    }

    @Experimental
    public static <T> BlockingSingle<T> from(Single<? extends T> single) {
        return new BlockingSingle<T>(single);
    }

    @Experimental
    public T value() {
        final AtomicReference returnItem = new AtomicReference();
        final AtomicReference returnException = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        Subscription subscription = this.single.subscribe(new SingleSubscriber<T>(){

            @Override
            public void onSuccess(T value) {
                returnItem.set(value);
                latch.countDown();
            }

            @Override
            public void onError(Throwable error) {
                returnException.set(error);
                latch.countDown();
            }
        });
        BlockingUtils.awaitForComplete(latch, subscription);
        Throwable throwable = (Throwable)returnException.get();
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        return (T)returnItem.get();
    }

    @Experimental
    public Future<T> toFuture() {
        return BlockingOperatorToFuture.toFuture(this.single.toObservable());
    }
}

