/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.schedulers;

import com.lambdaworks.rx.Scheduler;
import com.lambdaworks.rx.annotations.Experimental;
import com.lambdaworks.rx.internal.schedulers.ExecutorScheduler;
import com.lambdaworks.rx.internal.schedulers.GenericScheduledExecutorService;
import com.lambdaworks.rx.internal.schedulers.ImmediateScheduler;
import com.lambdaworks.rx.internal.schedulers.SchedulerLifecycle;
import com.lambdaworks.rx.internal.schedulers.TrampolineScheduler;
import com.lambdaworks.rx.internal.util.RxRingBuffer;
import com.lambdaworks.rx.plugins.RxJavaPlugins;
import com.lambdaworks.rx.plugins.RxJavaSchedulersHook;
import com.lambdaworks.rx.schedulers.TestScheduler;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class Schedulers {
    private final Scheduler computationScheduler;
    private final Scheduler ioScheduler;
    private final Scheduler newThreadScheduler;
    private static final AtomicReference<Schedulers> INSTANCE = new AtomicReference();

    private static Schedulers getInstance() {
        Schedulers current;
        while ((current = INSTANCE.get()) == null) {
            current = new Schedulers();
            if (INSTANCE.compareAndSet(null, current)) {
                return current;
            }
            current.shutdownInstance();
        }
        return current;
    }

    private Schedulers() {
        RxJavaSchedulersHook hook = RxJavaPlugins.getInstance().getSchedulersHook();
        Scheduler c = hook.getComputationScheduler();
        this.computationScheduler = c != null ? c : RxJavaSchedulersHook.createComputationScheduler();
        Scheduler io = hook.getIOScheduler();
        this.ioScheduler = io != null ? io : RxJavaSchedulersHook.createIoScheduler();
        Scheduler nt = hook.getNewThreadScheduler();
        this.newThreadScheduler = nt != null ? nt : RxJavaSchedulersHook.createNewThreadScheduler();
    }

    public static Scheduler immediate() {
        return ImmediateScheduler.INSTANCE;
    }

    public static Scheduler trampoline() {
        return TrampolineScheduler.INSTANCE;
    }

    public static Scheduler newThread() {
        return Schedulers.getInstance().newThreadScheduler;
    }

    public static Scheduler computation() {
        return Schedulers.getInstance().computationScheduler;
    }

    public static Scheduler io() {
        return Schedulers.getInstance().ioScheduler;
    }

    public static TestScheduler test() {
        return new TestScheduler();
    }

    public static Scheduler from(Executor executor) {
        return new ExecutorScheduler(executor);
    }

    @Experimental
    public static void reset() {
        Schedulers s = INSTANCE.getAndSet(null);
        if (s != null) {
            s.shutdownInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void start() {
        Schedulers s = Schedulers.getInstance();
        s.startInstance();
        Schedulers schedulers = s;
        synchronized (schedulers) {
            GenericScheduledExecutorService.INSTANCE.start();
            RxRingBuffer.SPSC_POOL.start();
            RxRingBuffer.SPMC_POOL.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Schedulers s = Schedulers.getInstance();
        s.shutdownInstance();
        Schedulers schedulers = s;
        synchronized (schedulers) {
            GenericScheduledExecutorService.INSTANCE.shutdown();
            RxRingBuffer.SPSC_POOL.shutdown();
            RxRingBuffer.SPMC_POOL.shutdown();
        }
    }

    synchronized void startInstance() {
        if (this.computationScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.computationScheduler)).start();
        }
        if (this.ioScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.ioScheduler)).start();
        }
        if (this.newThreadScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.newThreadScheduler)).start();
        }
    }

    synchronized void shutdownInstance() {
        if (this.computationScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.computationScheduler)).shutdown();
        }
        if (this.ioScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.ioScheduler)).shutdown();
        }
        if (this.newThreadScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.newThreadScheduler)).shutdown();
        }
    }
}

