/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.plugins;

import com.lambdaworks.rx.Scheduler;
import com.lambdaworks.rx.annotations.Experimental;
import com.lambdaworks.rx.functions.Action0;
import com.lambdaworks.rx.internal.schedulers.CachedThreadScheduler;
import com.lambdaworks.rx.internal.schedulers.EventLoopsScheduler;
import com.lambdaworks.rx.internal.schedulers.NewThreadScheduler;
import com.lambdaworks.rx.internal.util.RxThreadFactory;
import java.util.concurrent.ThreadFactory;

public class RxJavaSchedulersHook {
    private static final RxJavaSchedulersHook DEFAULT_INSTANCE = new RxJavaSchedulersHook();

    @Experimental
    public static Scheduler createComputationScheduler() {
        return RxJavaSchedulersHook.createComputationScheduler(new RxThreadFactory("RxComputationScheduler-"));
    }

    @Experimental
    public static Scheduler createComputationScheduler(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory == null");
        }
        return new EventLoopsScheduler(threadFactory);
    }

    @Experimental
    public static Scheduler createIoScheduler() {
        return RxJavaSchedulersHook.createIoScheduler(new RxThreadFactory("RxIoScheduler-"));
    }

    @Experimental
    public static Scheduler createIoScheduler(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory == null");
        }
        return new CachedThreadScheduler(threadFactory);
    }

    @Experimental
    public static Scheduler createNewThreadScheduler() {
        return RxJavaSchedulersHook.createNewThreadScheduler(new RxThreadFactory("RxNewThreadScheduler-"));
    }

    @Experimental
    public static Scheduler createNewThreadScheduler(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory == null");
        }
        return new NewThreadScheduler(threadFactory);
    }

    protected RxJavaSchedulersHook() {
    }

    public Scheduler getComputationScheduler() {
        return null;
    }

    public Scheduler getIOScheduler() {
        return null;
    }

    public Scheduler getNewThreadScheduler() {
        return null;
    }

    public Action0 onSchedule(Action0 action) {
        return action;
    }

    public static RxJavaSchedulersHook getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }
}

