/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.observers;

import com.lambdaworks.rx.Notification;
import com.lambdaworks.rx.Observer;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.CompositeException;
import com.lambdaworks.rx.observers.TestObserver;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class TestSubscriber<T>
extends Subscriber<T> {
    private final TestObserver<T> testObserver;
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile Thread lastSeenThread;
    private static final Observer<Object> INERT = new Observer<Object>(){

        @Override
        public void onCompleted() {
        }

        @Override
        public void onError(Throwable e) {
        }

        @Override
        public void onNext(Object t) {
        }
    };

    public TestSubscriber(long initialRequest) {
        this(INERT, initialRequest);
    }

    public TestSubscriber(Observer<T> delegate, long initialRequest) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.testObserver = new TestObserver<T>(delegate);
        if (initialRequest >= 0L) {
            this.request(initialRequest);
        }
    }

    public TestSubscriber(Subscriber<T> delegate) {
        this(delegate, -1L);
    }

    public TestSubscriber(Observer<T> delegate) {
        this(delegate, -1L);
    }

    public TestSubscriber() {
        this(-1L);
    }

    public static <T> TestSubscriber<T> create() {
        return new TestSubscriber<T>();
    }

    public static <T> TestSubscriber<T> create(long initialRequest) {
        return new TestSubscriber<T>(initialRequest);
    }

    public static <T> TestSubscriber<T> create(Observer<T> delegate, long initialRequest) {
        return new TestSubscriber<T>(delegate, initialRequest);
    }

    public static <T> TestSubscriber<T> create(Subscriber<T> delegate) {
        return new TestSubscriber<T>(delegate);
    }

    public static <T> TestSubscriber<T> create(Observer<T> delegate) {
        return new TestSubscriber<T>(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        try {
            this.lastSeenThread = Thread.currentThread();
            this.testObserver.onCompleted();
        }
        finally {
            this.latch.countDown();
        }
    }

    public List<Notification<T>> getOnCompletedEvents() {
        return this.testObserver.getOnCompletedEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable e) {
        try {
            this.lastSeenThread = Thread.currentThread();
            this.testObserver.onError(e);
        }
        finally {
            this.latch.countDown();
        }
    }

    public List<Throwable> getOnErrorEvents() {
        return this.testObserver.getOnErrorEvents();
    }

    @Override
    public void onNext(T t) {
        this.lastSeenThread = Thread.currentThread();
        this.testObserver.onNext(t);
    }

    public void requestMore(long n) {
        this.request(n);
    }

    public List<T> getOnNextEvents() {
        return this.testObserver.getOnNextEvents();
    }

    public void assertReceivedOnNext(List<T> items) {
        this.testObserver.assertReceivedOnNext(items);
    }

    public void assertTerminalEvent() {
        this.testObserver.assertTerminalEvent();
    }

    public void assertUnsubscribed() {
        if (!this.isUnsubscribed()) {
            this.testObserver.assertionError("Not unsubscribed.");
        }
    }

    public void assertNoErrors() {
        List<Throwable> onErrorEvents = this.getOnErrorEvents();
        if (onErrorEvents.size() > 0) {
            AssertionError ae = new AssertionError((Object)("Unexpected onError events: " + this.getOnErrorEvents().size()));
            if (onErrorEvents.size() == 1) {
                ((Throwable)((Object)ae)).initCause(this.getOnErrorEvents().get(0));
            } else {
                ((Throwable)((Object)ae)).initCause(new CompositeException(onErrorEvents));
            }
            throw ae;
        }
    }

    public void awaitTerminalEvent() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
    }

    public void awaitTerminalEvent(long timeout, TimeUnit unit) {
        try {
            this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
    }

    public void awaitTerminalEventAndUnsubscribeOnTimeout(long timeout, TimeUnit unit) {
        try {
            boolean result = this.latch.await(timeout, unit);
            if (!result) {
                this.unsubscribe();
            }
        }
        catch (InterruptedException e) {
            this.unsubscribe();
        }
    }

    public Thread getLastSeenThread() {
        return this.lastSeenThread;
    }

    public void assertCompleted() {
        int s = this.testObserver.getOnCompletedEvents().size();
        if (s == 0) {
            this.testObserver.assertionError("Not completed!");
        } else if (s > 1) {
            this.testObserver.assertionError("Completed multiple times: " + s);
        }
    }

    public void assertNotCompleted() {
        int s = this.testObserver.getOnCompletedEvents().size();
        if (s == 1) {
            this.testObserver.assertionError("Completed!");
        } else if (s > 1) {
            this.testObserver.assertionError("Completed multiple times: " + s);
        }
    }

    public void assertError(Class<? extends Throwable> clazz) {
        List<Throwable> err = this.testObserver.getOnErrorEvents();
        if (err.size() == 0) {
            this.testObserver.assertionError("No errors");
        } else {
            if (err.size() > 1) {
                AssertionError ae = new AssertionError((Object)("Multiple errors: " + err.size()));
                ((Throwable)((Object)ae)).initCause(new CompositeException(err));
                throw ae;
            }
            if (!clazz.isInstance(err.get(0))) {
                AssertionError ae = new AssertionError((Object)("Exceptions differ; expected: " + clazz + ", actual: " + err.get(0)));
                ((Throwable)((Object)ae)).initCause(err.get(0));
                throw ae;
            }
        }
    }

    public void assertError(Throwable throwable) {
        List<Throwable> err = this.testObserver.getOnErrorEvents();
        if (err.size() == 0) {
            this.testObserver.assertionError("No errors");
        } else {
            if (err.size() > 1) {
                AssertionError ae = new AssertionError((Object)("Multiple errors: " + err.size()));
                ((Throwable)((Object)ae)).initCause(new CompositeException(err));
                throw ae;
            }
            if (!throwable.equals(err.get(0))) {
                AssertionError ae = new AssertionError((Object)("Exceptions differ; expected: " + throwable + ", actual: " + err.get(0)));
                ((Throwable)((Object)ae)).initCause(err.get(0));
                throw ae;
            }
        }
    }

    public void assertNoTerminalEvent() {
        List<Throwable> err = this.testObserver.getOnErrorEvents();
        int s = this.testObserver.getOnCompletedEvents().size();
        if (err.size() > 0 || s > 0) {
            if (err.isEmpty()) {
                this.testObserver.assertionError("Found " + err.size() + " errors and " + s + " completion events instead of none");
            } else {
                if (err.size() == 1) {
                    AssertionError ae = new AssertionError((Object)("Found " + err.size() + " errors and " + s + " completion events instead of none"));
                    ((Throwable)((Object)ae)).initCause(err.get(0));
                    throw ae;
                }
                AssertionError ae = new AssertionError((Object)("Found " + err.size() + " errors and " + s + " completion events instead of none"));
                ((Throwable)((Object)ae)).initCause(new CompositeException(err));
                throw ae;
            }
        }
    }

    public void assertNoValues() {
        int s = this.testObserver.getOnNextEvents().size();
        if (s > 0) {
            this.testObserver.assertionError("No onNext events expected yet some received: " + s);
        }
    }

    public void assertValueCount(int count) {
        int s = this.testObserver.getOnNextEvents().size();
        if (s != count) {
            this.testObserver.assertionError("Number of onNext events differ; expected: " + count + ", actual: " + s);
        }
    }

    public void assertValues(T ... values) {
        this.assertReceivedOnNext(Arrays.asList(values));
    }

    public void assertValue(T value) {
        this.assertReceivedOnNext(Collections.singletonList(value));
    }
}

