/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.observers;

import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.CompositeException;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.exceptions.OnCompletedFailedException;
import com.lambdaworks.rx.exceptions.OnErrorFailedException;
import com.lambdaworks.rx.exceptions.OnErrorNotImplementedException;
import com.lambdaworks.rx.exceptions.UnsubscribeFailedException;
import com.lambdaworks.rx.internal.util.RxJavaPluginUtils;
import java.util.Arrays;

public class SafeSubscriber<T>
extends Subscriber<T> {
    private final Subscriber<? super T> actual;
    boolean done = false;

    public SafeSubscriber(Subscriber<? super T> actual) {
        super(actual);
        this.actual = actual;
    }

    @Override
    public void onCompleted() {
        if (!this.done) {
            this.done = true;
            try {
                this.actual.onCompleted();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPluginUtils.handleException(e);
                throw new OnCompletedFailedException(e.getMessage(), e);
            }
            finally {
                try {
                    this.unsubscribe();
                }
                catch (Throwable e) {
                    RxJavaPluginUtils.handleException(e);
                    throw new UnsubscribeFailedException(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        Exceptions.throwIfFatal(e);
        if (!this.done) {
            this.done = true;
            this._onError(e);
        }
    }

    @Override
    public void onNext(T args) {
        try {
            if (!this.done) {
                this.actual.onNext(args);
            }
        }
        catch (Throwable e) {
            Exceptions.throwOrReport(e, this);
        }
    }

    protected void _onError(Throwable e) {
        RxJavaPluginUtils.handleException(e);
        try {
            this.actual.onError(e);
        }
        catch (Throwable e2) {
            if (e2 instanceof OnErrorNotImplementedException) {
                try {
                    this.unsubscribe();
                }
                catch (Throwable unsubscribeException) {
                    RxJavaPluginUtils.handleException(unsubscribeException);
                    throw new RuntimeException("Observer.onError not implemented and error while unsubscribing.", new CompositeException(Arrays.asList(e, unsubscribeException)));
                }
                throw (OnErrorNotImplementedException)e2;
            }
            RxJavaPluginUtils.handleException(e2);
            try {
                this.unsubscribe();
            }
            catch (Throwable unsubscribeException) {
                RxJavaPluginUtils.handleException(unsubscribeException);
                throw new OnErrorFailedException("Error occurred when trying to propagate error to Observer.onError and during unsubscription.", new CompositeException(Arrays.asList(e, e2, unsubscribeException)));
            }
            throw new OnErrorFailedException("Error occurred when trying to propagate error to Observer.onError", new CompositeException(Arrays.asList(e, e2)));
        }
        try {
            this.unsubscribe();
        }
        catch (RuntimeException unsubscribeException) {
            RxJavaPluginUtils.handleException(unsubscribeException);
            throw new OnErrorFailedException(unsubscribeException);
        }
    }

    public Subscriber<? super T> getActual() {
        return this.actual;
    }
}

