/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.observables;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Subscriber;

public class GroupedObservable<K, T>
extends Observable<T> {
    private final K key;

    public static <K, T> GroupedObservable<K, T> from(K key, final Observable<T> o) {
        return new GroupedObservable<K, T>(key, new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> s) {
                o.unsafeSubscribe(s);
            }
        });
    }

    public static <K, T> GroupedObservable<K, T> create(K key, Observable.OnSubscribe<T> f) {
        return new GroupedObservable<K, T>(key, f);
    }

    protected GroupedObservable(K key, Observable.OnSubscribe<T> onSubscribe) {
        super(onSubscribe);
        this.key = key;
    }

    public K getKey() {
        return this.key;
    }
}

