/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.util.atomic;

import com.lambdaworks.rx.internal.util.unsafe.Pow2;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class SpscExactAtomicArrayQueue<T>
extends AtomicReferenceArray<T>
implements Queue<T> {
    private static final long serialVersionUID = 6210984603741293445L;
    final int mask;
    final int capacitySkip;
    final AtomicLong producerIndex;
    final AtomicLong consumerIndex;

    public SpscExactAtomicArrayQueue(int capacity) {
        super(Pow2.roundToPowerOfTwo(capacity));
        int len = this.length();
        this.mask = len - 1;
        this.capacitySkip = len - capacity;
        this.producerIndex = new AtomicLong();
        this.consumerIndex = new AtomicLong();
    }

    @Override
    public boolean offer(T value) {
        int m;
        if (value == null) {
            throw new NullPointerException();
        }
        long pi = this.producerIndex.get();
        int fullCheck = (int)(pi + (long)this.capacitySkip) & (m = this.mask);
        if (this.get(fullCheck) != null) {
            return false;
        }
        int offset = (int)pi & m;
        this.producerIndex.lazySet(pi + 1L);
        this.lazySet(offset, value);
        return true;
    }

    @Override
    public T poll() {
        long ci = this.consumerIndex.get();
        int offset = (int)ci & this.mask;
        Object value = this.get(offset);
        if (value == null) {
            return null;
        }
        this.consumerIndex.lazySet(ci + 1L);
        this.lazySet(offset, null);
        return (T)value;
    }

    @Override
    public T peek() {
        return (T)this.get((int)this.consumerIndex.get() & this.mask);
    }

    @Override
    public void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    @Override
    public boolean isEmpty() {
        return this.producerIndex == this.consumerIndex;
    }

    @Override
    public int size() {
        long ci = this.consumerIndex.get();
        while (true) {
            long pi = this.producerIndex.get();
            long ci2 = this.consumerIndex.get();
            if (ci == ci2) {
                return (int)(pi - ci2);
            }
            ci = ci2;
        }
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T element() {
        throw new UnsupportedOperationException();
    }
}

