/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class SynchronizedQueue<T>
implements Queue<T> {
    private final LinkedList<T> list = new LinkedList();
    private final int size;

    public SynchronizedQueue() {
        this.size = -1;
    }

    public SynchronizedQueue(int size) {
        this.size = size;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public synchronized Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public synchronized int size() {
        return this.list.size();
    }

    @Override
    public synchronized boolean add(T e) {
        return this.list.add(e);
    }

    @Override
    public synchronized boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends T> c) {
        return this.list.addAll(c);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public synchronized void clear() {
        this.list.clear();
    }

    public synchronized String toString() {
        return this.list.toString();
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SynchronizedQueue other = (SynchronizedQueue)obj;
        return !(this.list == null ? other.list != null : !this.list.equals(other.list));
    }

    @Override
    public synchronized T peek() {
        return this.list.peek();
    }

    @Override
    public synchronized T element() {
        return this.list.element();
    }

    @Override
    public synchronized T poll() {
        return this.list.poll();
    }

    @Override
    public synchronized T remove() {
        return this.list.remove();
    }

    @Override
    public synchronized boolean offer(T e) {
        if (this.size > -1 && this.list.size() + 1 > this.size) {
            return false;
        }
        return this.list.offer(e);
    }

    public synchronized Object clone() {
        SynchronizedQueue<T> q = new SynchronizedQueue<T>(this.size);
        q.addAll((Collection<T>)this.list);
        return q;
    }

    @Override
    public synchronized Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public synchronized <R> R[] toArray(R[] a) {
        return this.list.toArray(a);
    }
}

