/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.util;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Producer;
import com.lambdaworks.rx.Scheduler;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.Subscription;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.functions.Action0;
import com.lambdaworks.rx.functions.Func1;
import com.lambdaworks.rx.internal.producers.SingleProducer;
import com.lambdaworks.rx.internal.schedulers.EventLoopsScheduler;
import com.lambdaworks.rx.observers.Subscribers;
import com.lambdaworks.rx.plugins.RxJavaObservableExecutionHook;
import com.lambdaworks.rx.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ScalarSynchronousObservable<T>
extends Observable<T> {
    static RxJavaObservableExecutionHook hook = RxJavaPlugins.getInstance().getObservableExecutionHook();
    static final boolean STRONG_MODE;
    final T t;

    static <T> Producer createProducer(Subscriber<? super T> s, T v) {
        if (STRONG_MODE) {
            return new SingleProducer<T>(s, v);
        }
        return new WeakSingleProducer<T>(s, v);
    }

    public static <T> ScalarSynchronousObservable<T> create(T t) {
        return new ScalarSynchronousObservable<T>(t);
    }

    protected ScalarSynchronousObservable(T t) {
        super(hook.onCreate(new JustOnSubscribe<T>(t)));
        this.t = t;
    }

    public T get() {
        return this.t;
    }

    public Observable<T> scalarScheduleOn(final Scheduler scheduler) {
        Func1<Action0, Subscription> onSchedule;
        if (scheduler instanceof EventLoopsScheduler) {
            final EventLoopsScheduler els = (EventLoopsScheduler)scheduler;
            onSchedule = new Func1<Action0, Subscription>(){

                @Override
                public Subscription call(Action0 a) {
                    return els.scheduleDirect(a);
                }
            };
        } else {
            onSchedule = new Func1<Action0, Subscription>(){

                @Override
                public Subscription call(final Action0 a) {
                    final Scheduler.Worker w = scheduler.createWorker();
                    w.schedule(new Action0(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void call() {
                            try {
                                a.call();
                            }
                            finally {
                                w.unsubscribe();
                            }
                        }
                    });
                    return w;
                }
            };
        }
        return ScalarSynchronousObservable.create(new ScalarAsyncOnSubscribe<T>(this.t, onSchedule));
    }

    public <R> Observable<R> scalarFlatMap(final Func1<? super T, ? extends Observable<? extends R>> func) {
        return ScalarSynchronousObservable.create(new Observable.OnSubscribe<R>(){

            @Override
            public void call(Subscriber<? super R> child) {
                Observable o = (Observable)func.call(ScalarSynchronousObservable.this.t);
                if (o instanceof ScalarSynchronousObservable) {
                    child.setProducer(ScalarSynchronousObservable.createProducer(child, ((ScalarSynchronousObservable)o).t));
                } else {
                    o.unsafeSubscribe(Subscribers.wrap(child));
                }
            }
        });
    }

    static {
        String wp = System.getProperty("com.lambdaworks.rx.just.strong-mode", "false");
        STRONG_MODE = Boolean.valueOf(wp);
    }

    static final class WeakSingleProducer<T>
    implements Producer {
        final Subscriber<? super T> actual;
        final T value;
        boolean once;

        public WeakSingleProducer(Subscriber<? super T> actual, T value) {
            this.actual = actual;
            this.value = value;
        }

        @Override
        public void request(long n) {
            if (this.once) {
                return;
            }
            if (n < 0L) {
                throw new IllegalStateException("n >= required but it was " + n);
            }
            if (n == 0L) {
                return;
            }
            this.once = true;
            Subscriber<T> a = this.actual;
            if (a.isUnsubscribed()) {
                return;
            }
            T v = this.value;
            try {
                a.onNext(v);
            }
            catch (Throwable e) {
                Exceptions.throwOrReport(e, a, v);
                return;
            }
            if (a.isUnsubscribed()) {
                return;
            }
            a.onCompleted();
        }
    }

    static final class ScalarAsyncProducer<T>
    extends AtomicBoolean
    implements Producer,
    Action0 {
        private static final long serialVersionUID = -2466317989629281651L;
        final Subscriber<? super T> actual;
        final T value;
        final Func1<Action0, Subscription> onSchedule;

        public ScalarAsyncProducer(Subscriber<? super T> actual, T value, Func1<Action0, Subscription> onSchedule) {
            this.actual = actual;
            this.value = value;
            this.onSchedule = onSchedule;
        }

        @Override
        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required but it was " + n);
            }
            if (n != 0L && this.compareAndSet(false, true)) {
                this.actual.add(this.onSchedule.call(this));
            }
        }

        @Override
        public void call() {
            Subscriber<T> a = this.actual;
            if (a.isUnsubscribed()) {
                return;
            }
            T v = this.value;
            try {
                a.onNext(v);
            }
            catch (Throwable e) {
                Exceptions.throwOrReport(e, a, v);
                return;
            }
            if (a.isUnsubscribed()) {
                return;
            }
            a.onCompleted();
        }

        @Override
        public String toString() {
            return "ScalarAsyncProducer[" + this.value + ", " + this.get() + "]";
        }
    }

    static final class ScalarAsyncOnSubscribe<T>
    implements Observable.OnSubscribe<T> {
        final T value;
        final Func1<Action0, Subscription> onSchedule;

        ScalarAsyncOnSubscribe(T value, Func1<Action0, Subscription> onSchedule) {
            this.value = value;
            this.onSchedule = onSchedule;
        }

        @Override
        public void call(Subscriber<? super T> s) {
            s.setProducer(new ScalarAsyncProducer<T>(s, this.value, this.onSchedule));
        }
    }

    static final class JustOnSubscribe<T>
    implements Observable.OnSubscribe<T> {
        final T value;

        JustOnSubscribe(T value) {
            this.value = value;
        }

        @Override
        public void call(Subscriber<? super T> s) {
            s.setProducer(ScalarSynchronousObservable.createProducer(s, this.value));
        }
    }
}

