/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.util;

import com.lambdaworks.rx.functions.Action1;
import com.lambdaworks.rx.internal.util.unsafe.Pow2;
import java.util.Arrays;

public final class OpenHashSet<T> {
    final float loadFactor;
    int mask;
    int size;
    int maxSize;
    T[] keys;
    private static final int INT_PHI = -1640531527;

    public OpenHashSet() {
        this(16, 0.75f);
    }

    public OpenHashSet(int capacity) {
        this(capacity, 0.75f);
    }

    public OpenHashSet(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        int c = Pow2.roundToPowerOfTwo(capacity);
        this.mask = c - 1;
        this.maxSize = (int)(loadFactor * (float)c);
        this.keys = new Object[c];
    }

    public boolean add(T value) {
        T[] a = this.keys;
        int m = this.mask;
        int pos = OpenHashSet.mix(value.hashCode()) & m;
        T curr = a[pos];
        if (curr != null) {
            if (curr.equals(value)) {
                return false;
            }
            while ((curr = a[pos = pos + 1 & m]) != null) {
                if (!curr.equals(value)) continue;
                return false;
            }
        }
        a[pos] = value;
        if (++this.size >= this.maxSize) {
            this.rehash();
        }
        return true;
    }

    public boolean remove(T value) {
        T[] a = this.keys;
        int m = this.mask;
        int pos = OpenHashSet.mix(value.hashCode()) & m;
        T curr = a[pos];
        if (curr == null) {
            return false;
        }
        if (curr.equals(value)) {
            return this.removeEntry(pos, a, m);
        }
        do {
            if ((curr = a[pos = pos + 1 & m]) != null) continue;
            return false;
        } while (!curr.equals(value));
        return this.removeEntry(pos, a, m);
    }

    boolean removeEntry(int pos, T[] a, int m) {
        --this.size;
        while (true) {
            T curr;
            int last = pos;
            pos = pos + 1 & m;
            while (true) {
                if ((curr = a[pos]) == null) {
                    a[last] = null;
                    return true;
                }
                int slot = OpenHashSet.mix(curr.hashCode()) & m;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & m;
            }
            a[last] = curr;
        }
    }

    public void clear(Action1<? super T> clearAction) {
        if (this.size == 0) {
            return;
        }
        Object[] a = this.keys;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            T e = a[i];
            if (e == null) continue;
            clearAction.call(e);
        }
        Arrays.fill(a, null);
        this.size = 0;
    }

    public void terminate() {
        this.size = 0;
        this.keys = new Object[0];
    }

    void rehash() {
        T[] a = this.keys;
        int i = a.length;
        int newCap = i << 1;
        int m = newCap - 1;
        Object[] b = new Object[newCap];
        int j = this.size;
        while (j-- != 0) {
            while (a[--i] == null) {
            }
            int pos = OpenHashSet.mix(a[i].hashCode()) & m;
            if (b[pos] != null) {
                while (b[pos = pos + 1 & m] != null) {
                }
            }
            b[pos] = a[i];
        }
        this.mask = m;
        this.maxSize = (int)((float)newCap * this.loadFactor);
        this.keys = b;
    }

    static int mix(int x) {
        int h = x * -1640531527;
        return h ^ h >>> 16;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public T[] values() {
        return this.keys;
    }
}

