/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.util;

import com.lambdaworks.rx.exceptions.CompositeException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;

public enum ExceptionsUtils {

    private static final Throwable TERMINATED = new Throwable("Terminated");

    public static boolean addThrowable(AtomicReference<Throwable> field, Throwable error) {
        Throwable next;
        Throwable current;
        do {
            if ((current = field.get()) == TERMINATED) {
                return false;
            }
            if (current == null) {
                next = error;
                continue;
            }
            if (current instanceof CompositeException) {
                ArrayList<Throwable> list = new ArrayList<Throwable>(((CompositeException)current).getExceptions());
                list.add(error);
                next = new CompositeException(list);
                continue;
            }
            next = new CompositeException(current, error);
        } while (!field.compareAndSet(current, next));
        return true;
    }

    public static Throwable terminate(AtomicReference<Throwable> field) {
        Throwable current = field.get();
        if (current != TERMINATED) {
            current = field.getAndSet(TERMINATED);
        }
        return current;
    }

    public static boolean isTerminated(AtomicReference<Throwable> field) {
        return ExceptionsUtils.isTerminated(field.get());
    }

    public static boolean isTerminated(Throwable error) {
        return error == TERMINATED;
    }
}

