/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.schedulers;

import com.lambdaworks.rx.Scheduler;
import com.lambdaworks.rx.Subscription;
import com.lambdaworks.rx.functions.Action0;
import com.lambdaworks.rx.internal.schedulers.SleepingAction;
import com.lambdaworks.rx.subscriptions.BooleanSubscription;
import com.lambdaworks.rx.subscriptions.Subscriptions;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class TrampolineScheduler
extends Scheduler {
    public static final TrampolineScheduler INSTANCE = new TrampolineScheduler();

    @Override
    public Scheduler.Worker createWorker() {
        return new InnerCurrentThreadScheduler();
    }

    private TrampolineScheduler() {
    }

    static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static final class TimedAction
    implements Comparable<TimedAction> {
        final Action0 action;
        final Long execTime;
        final int count;

        TimedAction(Action0 action, Long execTime, int count) {
            this.action = action;
            this.execTime = execTime;
            this.count = count;
        }

        @Override
        public int compareTo(TimedAction that) {
            int result = this.execTime.compareTo(that.execTime);
            if (result == 0) {
                return TrampolineScheduler.compare(this.count, that.count);
            }
            return result;
        }
    }

    private static class InnerCurrentThreadScheduler
    extends Scheduler.Worker
    implements Subscription {
        final AtomicInteger counter = new AtomicInteger();
        final PriorityBlockingQueue<TimedAction> queue = new PriorityBlockingQueue();
        private final BooleanSubscription innerSubscription = new BooleanSubscription();
        private final AtomicInteger wip = new AtomicInteger();

        InnerCurrentThreadScheduler() {
        }

        @Override
        public Subscription schedule(Action0 action) {
            return this.enqueue(action, this.now());
        }

        @Override
        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            long execTime = this.now() + unit.toMillis(delayTime);
            return this.enqueue(new SleepingAction(action, this, execTime), execTime);
        }

        private Subscription enqueue(Action0 action, long execTime) {
            if (this.innerSubscription.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            final TimedAction timedAction = new TimedAction(action, execTime, this.counter.incrementAndGet());
            this.queue.add(timedAction);
            if (this.wip.getAndIncrement() == 0) {
                do {
                    TimedAction polled;
                    if ((polled = this.queue.poll()) == null) continue;
                    polled.action.call();
                } while (this.wip.decrementAndGet() > 0);
                return Subscriptions.unsubscribed();
            }
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    InnerCurrentThreadScheduler.this.queue.remove(timedAction);
                }
            });
        }

        @Override
        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }
    }
}

