/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.producers;

import com.lambdaworks.rx.Observer;
import com.lambdaworks.rx.Producer;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.exceptions.MissingBackpressureException;
import com.lambdaworks.rx.internal.operators.BackpressureUtils;
import com.lambdaworks.rx.internal.util.atomic.SpscLinkedAtomicQueue;
import com.lambdaworks.rx.internal.util.unsafe.SpscLinkedQueue;
import com.lambdaworks.rx.internal.util.unsafe.UnsafeAccess;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class QueuedProducer<T>
extends AtomicLong
implements Producer,
Observer<T> {
    private static final long serialVersionUID = 7277121710709137047L;
    final Subscriber<? super T> child;
    final Queue<Object> queue;
    final AtomicInteger wip;
    Throwable error;
    volatile boolean done;
    static final Object NULL_SENTINEL = new Object();

    public QueuedProducer(Subscriber<? super T> child) {
        this(child, UnsafeAccess.isUnsafeAvailable() ? new SpscLinkedQueue() : new SpscLinkedAtomicQueue());
    }

    public QueuedProducer(Subscriber<? super T> child, Queue<Object> queue) {
        this.child = child;
        this.queue = queue;
        this.wip = new AtomicInteger();
    }

    @Override
    public void request(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n >= 0 required");
        }
        if (n > 0L) {
            BackpressureUtils.getAndAddRequest(this, n);
            this.drain();
        }
    }

    public boolean offer(T value) {
        if (value == null ? !this.queue.offer(NULL_SENTINEL) : !this.queue.offer(value)) {
            return false;
        }
        this.drain();
        return true;
    }

    @Override
    public void onNext(T value) {
        if (!this.offer(value)) {
            this.onError(new MissingBackpressureException());
        }
    }

    @Override
    public void onError(Throwable e) {
        this.error = e;
        this.done = true;
        this.drain();
    }

    @Override
    public void onCompleted() {
        this.done = true;
        this.drain();
    }

    private boolean checkTerminated(boolean isDone, boolean isEmpty) {
        if (this.child.isUnsubscribed()) {
            return true;
        }
        if (isDone) {
            Throwable e = this.error;
            if (e != null) {
                this.queue.clear();
                this.child.onError(e);
                return true;
            }
            if (isEmpty) {
                this.child.onCompleted();
                return true;
            }
        }
        return false;
    }

    private void drain() {
        if (this.wip.getAndIncrement() == 0) {
            Subscriber<Object> c = this.child;
            Queue<Object> q = this.queue;
            do {
                if (this.checkTerminated(this.done, q.isEmpty())) {
                    return;
                }
                this.wip.lazySet(1);
                long r = this.get();
                long e = 0L;
                while (r != 0L) {
                    boolean d = this.done;
                    Object v = q.poll();
                    if (this.checkTerminated(d, v == null)) {
                        return;
                    }
                    if (v == null) break;
                    try {
                        if (v == NULL_SENTINEL) {
                            c.onNext(null);
                        } else {
                            Object t = v;
                            c.onNext(t);
                        }
                    }
                    catch (Throwable ex) {
                        Exceptions.throwOrReport(ex, c, v != NULL_SENTINEL ? v : null);
                        return;
                    }
                    --r;
                    ++e;
                }
                if (e == 0L || this.get() == Long.MAX_VALUE) continue;
                this.addAndGet(-e);
            } while (this.wip.decrementAndGet() != 0);
        }
    }
}

