/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Single;
import com.lambdaworks.rx.SingleSubscriber;
import com.lambdaworks.rx.exceptions.CompositeException;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.functions.Action1;
import com.lambdaworks.rx.functions.Func0;
import com.lambdaworks.rx.functions.Func1;
import com.lambdaworks.rx.plugins.RxJavaPlugins;
import java.util.Arrays;

public final class SingleOnSubscribeUsing<T, Resource>
implements Single.OnSubscribe<T> {
    final Func0<Resource> resourceFactory;
    final Func1<? super Resource, ? extends Single<? extends T>> singleFactory;
    final Action1<? super Resource> disposeAction;
    final boolean disposeEagerly;

    public SingleOnSubscribeUsing(Func0<Resource> resourceFactory, Func1<? super Resource, ? extends Single<? extends T>> observableFactory, Action1<? super Resource> disposeAction, boolean disposeEagerly) {
        this.resourceFactory = resourceFactory;
        this.singleFactory = observableFactory;
        this.disposeAction = disposeAction;
        this.disposeEagerly = disposeEagerly;
    }

    @Override
    public void call(final SingleSubscriber<? super T> child) {
        Single<T> single;
        Resource resource;
        try {
            resource = this.resourceFactory.call();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            child.onError(ex);
            return;
        }
        try {
            single = this.singleFactory.call(resource);
        }
        catch (Throwable ex) {
            this.handleSubscriptionTimeError(child, resource, ex);
            return;
        }
        if (single == null) {
            this.handleSubscriptionTimeError(child, resource, new NullPointerException("The single"));
            return;
        }
        SingleSubscriber parent = new SingleSubscriber<T>(){

            @Override
            public void onSuccess(T value) {
                if (SingleOnSubscribeUsing.this.disposeEagerly) {
                    try {
                        SingleOnSubscribeUsing.this.disposeAction.call(resource);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        child.onError(ex);
                        return;
                    }
                }
                child.onSuccess(value);
                if (!SingleOnSubscribeUsing.this.disposeEagerly) {
                    try {
                        SingleOnSubscribeUsing.this.disposeAction.call(resource);
                    }
                    catch (Throwable ex2) {
                        Exceptions.throwIfFatal(ex2);
                        RxJavaPlugins.getInstance().getErrorHandler().handleError(ex2);
                    }
                }
            }

            @Override
            public void onError(Throwable error) {
                SingleOnSubscribeUsing.this.handleSubscriptionTimeError(child, resource, error);
            }
        };
        child.add(parent);
        single.subscribe(parent);
    }

    void handleSubscriptionTimeError(SingleSubscriber<? super T> t, Resource resource, Throwable ex) {
        Exceptions.throwIfFatal(ex);
        if (this.disposeEagerly) {
            try {
                this.disposeAction.call(resource);
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                ex = new CompositeException(Arrays.asList(ex, ex2));
            }
        }
        t.onError(ex);
        if (!this.disposeEagerly) {
            try {
                this.disposeAction.call(resource);
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                RxJavaPlugins.getInstance().getErrorHandler().handleError(ex2);
            }
        }
    }
}

