/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.internal.producers.SingleDelayedProducer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class OperatorToObservableList<T>
implements Observable.Operator<List<T>, T> {
    public static <T> OperatorToObservableList<T> instance() {
        return Holder.INSTANCE;
    }

    OperatorToObservableList() {
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super List<T>> o) {
        final SingleDelayedProducer<? super List<T>> producer = new SingleDelayedProducer<List<T>>(o);
        Subscriber result = new Subscriber<T>(){
            boolean completed = false;
            List<T> list = new LinkedList();

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onCompleted() {
                if (!this.completed) {
                    ArrayList result;
                    this.completed = true;
                    try {
                        result = new ArrayList(this.list);
                    }
                    catch (Throwable t) {
                        Exceptions.throwOrReport(t, this);
                        return;
                    }
                    this.list = null;
                    producer.setValue(result);
                }
            }

            @Override
            public void onError(Throwable e) {
                o.onError(e);
            }

            @Override
            public void onNext(T value) {
                if (!this.completed) {
                    this.list.add(value);
                }
            }
        };
        o.add(result);
        o.setProducer(producer);
        return result;
    }

    private static final class Holder {
        static final OperatorToObservableList<Object> INSTANCE = new OperatorToObservableList();

        private Holder() {
        }
    }
}

