/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.functions.Func0;
import com.lambdaworks.rx.functions.Func1;
import com.lambdaworks.rx.observers.Subscribers;
import java.util.HashMap;
import java.util.Map;

public final class OperatorToMap<T, K, V>
implements Observable.Operator<Map<K, V>, T> {
    final Func1<? super T, ? extends K> keySelector;
    final Func1<? super T, ? extends V> valueSelector;
    private final Func0<? extends Map<K, V>> mapFactory;

    public OperatorToMap(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector) {
        this(keySelector, valueSelector, new DefaultToMapFactory());
    }

    public OperatorToMap(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, V>> mapFactory) {
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.mapFactory = mapFactory;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super Map<K, V>> subscriber) {
        Map<K, V> localMap;
        try {
            localMap = this.mapFactory.call();
        }
        catch (Throwable ex) {
            Exceptions.throwOrReport(ex, subscriber);
            Subscriber parent = Subscribers.empty();
            parent.unsubscribe();
            return parent;
        }
        final Map<K, V> fLocalMap = localMap;
        return new Subscriber<T>(subscriber){
            private Map<K, V> map;
            {
                super(x0);
                this.map = fLocalMap;
            }

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(T v) {
                Object value;
                Object key;
                try {
                    key = OperatorToMap.this.keySelector.call(v);
                    value = OperatorToMap.this.valueSelector.call(v);
                }
                catch (Throwable ex) {
                    Exceptions.throwOrReport(ex, subscriber);
                    return;
                }
                this.map.put(key, value);
            }

            @Override
            public void onError(Throwable e) {
                this.map = null;
                subscriber.onError(e);
            }

            @Override
            public void onCompleted() {
                Map map0 = this.map;
                this.map = null;
                subscriber.onNext(map0);
                subscriber.onCompleted();
            }
        };
    }

    public static final class DefaultToMapFactory<K, V>
    implements Func0<Map<K, V>> {
        @Override
        public Map<K, V> call() {
            return new HashMap();
        }
    }
}

