/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Scheduler;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.functions.Action0;
import com.lambdaworks.rx.observers.SerializedSubscriber;
import java.util.concurrent.TimeUnit;

public final class OperatorTakeTimed<T>
implements Observable.Operator<T, T> {
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;

    public OperatorTakeTimed(long time, TimeUnit unit, Scheduler scheduler) {
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        Scheduler.Worker worker = this.scheduler.createWorker();
        child.add(worker);
        TakeSubscriber<? super T> ts = new TakeSubscriber<T>(new SerializedSubscriber<T>(child));
        worker.schedule(ts, this.time, this.unit);
        return ts;
    }

    static final class TakeSubscriber<T>
    extends Subscriber<T>
    implements Action0 {
        final Subscriber<? super T> child;

        public TakeSubscriber(Subscriber<? super T> child) {
            super(child);
            this.child = child;
        }

        @Override
        public void onNext(T t) {
            this.child.onNext(t);
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
            this.unsubscribe();
        }

        @Override
        public void onCompleted() {
            this.child.onCompleted();
            this.unsubscribe();
        }

        @Override
        public void call() {
            this.onCompleted();
        }
    }
}

