/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.Subscription;
import com.lambdaworks.rx.observers.SerializedSubscriber;
import java.util.concurrent.atomic.AtomicReference;

public final class OperatorSampleWithObservable<T, U>
implements Observable.Operator<T, T> {
    final Observable<U> sampler;
    static final Object EMPTY_TOKEN = new Object();

    public OperatorSampleWithObservable(Observable<U> sampler) {
        this.sampler = sampler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        final AtomicReference<Object> value = new AtomicReference<Object>(EMPTY_TOKEN);
        final AtomicReference<2> main = new AtomicReference<2>();
        final Subscriber samplerSub = new Subscriber<U>(){

            @Override
            public void onNext(U t) {
                Object localValue = value.getAndSet(EMPTY_TOKEN);
                if (localValue != EMPTY_TOKEN) {
                    Object v = localValue;
                    s.onNext(v);
                }
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                ((Subscription)main.get()).unsubscribe();
            }

            @Override
            public void onCompleted() {
                this.onNext((U)null);
                s.onCompleted();
                ((Subscription)main.get()).unsubscribe();
            }
        };
        Subscriber result = new Subscriber<T>(){

            @Override
            public void onNext(T t) {
                value.set(t);
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                samplerSub.unsubscribe();
            }

            @Override
            public void onCompleted() {
                samplerSub.onNext(null);
                s.onCompleted();
                samplerSub.unsubscribe();
            }
        };
        main.lazySet(result);
        child.add(result);
        child.add(samplerSub);
        this.sampler.unsafeSubscribe(samplerSub);
        return result;
    }
}

