/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Producer;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.functions.Action1;
import com.lambdaworks.rx.internal.operators.BackpressureUtils;
import java.util.concurrent.atomic.AtomicLong;

public class OperatorOnBackpressureDrop<T>
implements Observable.Operator<T, T> {
    final Action1<? super T> onDrop;

    public static <T> OperatorOnBackpressureDrop<T> instance() {
        return Holder.INSTANCE;
    }

    OperatorOnBackpressureDrop() {
        this(null);
    }

    public OperatorOnBackpressureDrop(Action1<? super T> onDrop) {
        this.onDrop = onDrop;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final AtomicLong requested = new AtomicLong();
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                BackpressureUtils.getAndAddRequest(requested, n);
            }
        });
        return new Subscriber<T>(child){

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onCompleted() {
                child.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onNext(T t) {
                if (requested.get() > 0L) {
                    child.onNext(t);
                    requested.decrementAndGet();
                } else if (OperatorOnBackpressureDrop.this.onDrop != null) {
                    try {
                        OperatorOnBackpressureDrop.this.onDrop.call(t);
                    }
                    catch (Throwable e) {
                        Exceptions.throwOrReport(e, child, t);
                        return;
                    }
                }
            }
        };
    }

    private static final class Holder {
        static final OperatorOnBackpressureDrop<Object> INSTANCE = new OperatorOnBackpressureDrop();

        private Holder() {
        }
    }
}

