/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Producer;
import com.lambdaworks.rx.Scheduler;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.MissingBackpressureException;
import com.lambdaworks.rx.functions.Action0;
import com.lambdaworks.rx.internal.operators.BackpressureUtils;
import com.lambdaworks.rx.internal.operators.NotificationLite;
import com.lambdaworks.rx.internal.schedulers.ImmediateScheduler;
import com.lambdaworks.rx.internal.schedulers.TrampolineScheduler;
import com.lambdaworks.rx.internal.util.RxRingBuffer;
import com.lambdaworks.rx.internal.util.atomic.SpscAtomicArrayQueue;
import com.lambdaworks.rx.internal.util.unsafe.SpscArrayQueue;
import com.lambdaworks.rx.internal.util.unsafe.UnsafeAccess;
import com.lambdaworks.rx.plugins.RxJavaPlugins;
import com.lambdaworks.rx.schedulers.Schedulers;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;

public final class OperatorObserveOn<T>
implements Observable.Operator<T, T> {
    private final Scheduler scheduler;
    private final boolean delayError;
    private final int bufferSize;

    public OperatorObserveOn(Scheduler scheduler, boolean delayError) {
        this(scheduler, delayError, RxRingBuffer.SIZE);
    }

    public OperatorObserveOn(Scheduler scheduler, boolean delayError, int bufferSize) {
        this.scheduler = scheduler;
        this.delayError = delayError;
        this.bufferSize = bufferSize > 0 ? bufferSize : RxRingBuffer.SIZE;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        if (this.scheduler instanceof ImmediateScheduler) {
            return child;
        }
        if (this.scheduler instanceof TrampolineScheduler) {
            return child;
        }
        ObserveOnSubscriber<T> parent = new ObserveOnSubscriber<T>(this.scheduler, child, this.delayError, this.bufferSize);
        parent.init();
        return parent;
    }

    public static <T> Observable.Operator<T, T> rebatch(final int n) {
        return new Observable.Operator<T, T>(){

            @Override
            public Subscriber<? super T> call(Subscriber<? super T> child) {
                ObserveOnSubscriber parent = new ObserveOnSubscriber(Schedulers.immediate(), child, false, n);
                parent.init();
                return parent;
            }
        };
    }

    private static final class ObserveOnSubscriber<T>
    extends Subscriber<T>
    implements Action0 {
        final Subscriber<? super T> child;
        final Scheduler.Worker recursiveScheduler;
        final NotificationLite<T> on;
        final boolean delayError;
        final Queue<Object> queue;
        final int limit;
        volatile boolean finished;
        final AtomicLong requested = new AtomicLong();
        final AtomicLong counter = new AtomicLong();
        Throwable error;
        long emitted;

        public ObserveOnSubscriber(Scheduler scheduler, Subscriber<? super T> child, boolean delayError, int bufferSize) {
            this.child = child;
            this.recursiveScheduler = scheduler.createWorker();
            this.delayError = delayError;
            this.on = NotificationLite.instance();
            int calculatedSize = bufferSize > 0 ? bufferSize : RxRingBuffer.SIZE;
            this.limit = calculatedSize - (calculatedSize >> 2);
            this.queue = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue<Object>(calculatedSize) : new SpscAtomicArrayQueue<Object>(calculatedSize);
            this.request(calculatedSize);
        }

        void init() {
            Subscriber<T> localChild = this.child;
            localChild.setProducer(new Producer(){

                @Override
                public void request(long n) {
                    if (n > 0L) {
                        BackpressureUtils.getAndAddRequest(ObserveOnSubscriber.this.requested, n);
                        ObserveOnSubscriber.this.schedule();
                    }
                }
            });
            localChild.add(this.recursiveScheduler);
            localChild.add(this);
        }

        @Override
        public void onNext(T t) {
            if (this.isUnsubscribed() || this.finished) {
                return;
            }
            if (!this.queue.offer(this.on.next(t))) {
                this.onError(new MissingBackpressureException());
                return;
            }
            this.schedule();
        }

        @Override
        public void onCompleted() {
            if (this.isUnsubscribed() || this.finished) {
                return;
            }
            this.finished = true;
            this.schedule();
        }

        @Override
        public void onError(Throwable e) {
            if (this.isUnsubscribed() || this.finished) {
                RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                return;
            }
            this.error = e;
            this.finished = true;
            this.schedule();
        }

        protected void schedule() {
            if (this.counter.getAndIncrement() == 0L) {
                this.recursiveScheduler.schedule(this);
            }
        }

        @Override
        public void call() {
            long missed = 1L;
            long currentEmission = this.emitted;
            Queue<Object> q = this.queue;
            Subscriber<T> localChild = this.child;
            NotificationLite<T> localOn = this.on;
            do {
                long requestAmount = this.requested.get();
                while (requestAmount != currentEmission) {
                    boolean empty;
                    boolean done = this.finished;
                    Object v = q.poll();
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(done, empty, localChild, q)) {
                        return;
                    }
                    if (empty) break;
                    localChild.onNext(localOn.getValue(v));
                    if (++currentEmission != (long)this.limit) continue;
                    requestAmount = BackpressureUtils.produced(this.requested, currentEmission);
                    this.request(currentEmission);
                    currentEmission = 0L;
                }
                if (requestAmount == currentEmission && this.checkTerminated(this.finished, q.isEmpty(), localChild, q)) {
                    return;
                }
                this.emitted = currentEmission;
            } while ((missed = this.counter.addAndGet(-missed)) != 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkTerminated(boolean done, boolean isEmpty, Subscriber<? super T> a, Queue<Object> q) {
            if (a.isUnsubscribed()) {
                q.clear();
                return true;
            }
            if (done) {
                if (this.delayError) {
                    if (isEmpty) {
                        Throwable e = this.error;
                        try {
                            if (e != null) {
                                a.onError(e);
                            }
                            a.onCompleted();
                        }
                        finally {
                            this.recursiveScheduler.unsubscribe();
                        }
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        q.clear();
                        try {
                            a.onError(e);
                        }
                        finally {
                            this.recursiveScheduler.unsubscribe();
                        }
                        return true;
                    }
                    if (isEmpty) {
                        try {
                            a.onCompleted();
                        }
                        finally {
                            this.recursiveScheduler.unsubscribe();
                        }
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

