/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Notification;
import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Producer;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.internal.operators.BackpressureUtils;
import com.lambdaworks.rx.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;

public final class OperatorMaterialize<T>
implements Observable.Operator<Notification<T>, T> {
    public static <T> OperatorMaterialize<T> instance() {
        return Holder.INSTANCE;
    }

    OperatorMaterialize() {
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Notification<T>> child) {
        final ParentSubscriber parent = new ParentSubscriber(child);
        child.add(parent);
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                if (n > 0L) {
                    parent.requestMore(n);
                }
            }
        });
        return parent;
    }

    private static class ParentSubscriber<T>
    extends Subscriber<T> {
        private final Subscriber<? super Notification<T>> child;
        private volatile Notification<T> terminalNotification;
        private boolean busy = false;
        private boolean missed = false;
        private final AtomicLong requested = new AtomicLong();

        ParentSubscriber(Subscriber<? super Notification<T>> child) {
            this.child = child;
        }

        @Override
        public void onStart() {
            this.request(0L);
        }

        void requestMore(long n) {
            BackpressureUtils.getAndAddRequest(this.requested, n);
            this.request(n);
            this.drain();
        }

        @Override
        public void onCompleted() {
            this.terminalNotification = Notification.createOnCompleted();
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.terminalNotification = Notification.createOnError(e);
            RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
            this.drain();
        }

        @Override
        public void onNext(T t) {
            this.child.onNext(Notification.createOnNext(t));
            this.decrementRequested();
        }

        private void decrementRequested() {
            long r;
            AtomicLong localRequested = this.requested;
            do {
                if ((r = localRequested.get()) != Long.MAX_VALUE) continue;
                return;
            } while (!localRequested.compareAndSet(r, r - 1L));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drain() {
            ParentSubscriber parentSubscriber = this;
            synchronized (parentSubscriber) {
                if (this.busy) {
                    this.missed = true;
                    return;
                }
            }
            AtomicLong localRequested = this.requested;
            while (!this.child.isUnsubscribed()) {
                Notification<T> tn = this.terminalNotification;
                if (tn != null && localRequested.get() > 0L) {
                    this.terminalNotification = null;
                    this.child.onNext(tn);
                    if (!this.child.isUnsubscribed()) {
                        this.child.onCompleted();
                    }
                    return;
                }
                ParentSubscriber parentSubscriber2 = this;
                synchronized (parentSubscriber2) {
                    if (!this.missed) {
                        this.busy = false;
                        return;
                    }
                }
            }
        }
    }

    private static final class Holder {
        static final OperatorMaterialize<Object> INSTANCE = new OperatorMaterialize();

        private Holder() {
        }
    }
}

