/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Producer;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.exceptions.OnErrorThrowable;
import com.lambdaworks.rx.functions.Func1;
import com.lambdaworks.rx.internal.util.RxJavaPluginUtils;

public final class OperatorMap<T, R>
implements Observable.Operator<R, T> {
    final Func1<? super T, ? extends R> transformer;

    public OperatorMap(Func1<? super T, ? extends R> transformer) {
        this.transformer = transformer;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super R> o) {
        MapSubscriber<? super T, ? extends R> parent = new MapSubscriber<T, R>(o, this.transformer);
        o.add(parent);
        return parent;
    }

    static final class MapSubscriber<T, R>
    extends Subscriber<T> {
        final Subscriber<? super R> actual;
        final Func1<? super T, ? extends R> mapper;
        boolean done;

        public MapSubscriber(Subscriber<? super R> actual, Func1<? super T, ? extends R> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        @Override
        public void onNext(T t) {
            R result;
            try {
                result = this.mapper.call(t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.onError(OnErrorThrowable.addValueAsLastCause(ex, t));
                return;
            }
            this.actual.onNext(result);
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPluginUtils.handleException(e);
                return;
            }
            this.done = true;
            this.actual.onError(e);
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.actual.onCompleted();
        }

        @Override
        public void setProducer(Producer p) {
            this.actual.setProducer(p);
        }
    }
}

