/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Observer;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.CompositeException;
import com.lambdaworks.rx.exceptions.Exceptions;
import java.util.Arrays;

public class OperatorDoOnEach<T>
implements Observable.Operator<T, T> {
    final Observer<? super T> doOnEachObserver;

    public OperatorDoOnEach(Observer<? super T> doOnEachObserver) {
        this.doOnEachObserver = doOnEachObserver;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> observer) {
        return new Subscriber<T>(observer){
            private boolean done;
            {
                super(x0);
                this.done = false;
            }

            @Override
            public void onCompleted() {
                if (this.done) {
                    return;
                }
                try {
                    OperatorDoOnEach.this.doOnEachObserver.onCompleted();
                }
                catch (Throwable e) {
                    Exceptions.throwOrReport(e, this);
                    return;
                }
                this.done = true;
                observer.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                Exceptions.throwIfFatal(e);
                if (this.done) {
                    return;
                }
                this.done = true;
                try {
                    OperatorDoOnEach.this.doOnEachObserver.onError(e);
                }
                catch (Throwable e2) {
                    Exceptions.throwIfFatal(e2);
                    observer.onError(new CompositeException(Arrays.asList(e, e2)));
                    return;
                }
                observer.onError(e);
            }

            @Override
            public void onNext(T value) {
                if (this.done) {
                    return;
                }
                try {
                    OperatorDoOnEach.this.doOnEachObserver.onNext(value);
                }
                catch (Throwable e) {
                    Exceptions.throwOrReport(e, this, value);
                    return;
                }
                observer.onNext(value);
            }
        };
    }
}

