/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.functions.Action0;
import com.lambdaworks.rx.plugins.RxJavaPlugins;

public final class OperatorDoAfterTerminate<T>
implements Observable.Operator<T, T> {
    final Action0 action;

    public OperatorDoAfterTerminate(Action0 action) {
        if (action == null) {
            throw new NullPointerException("Action can not be null");
        }
        this.action = action;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){

            @Override
            public void onNext(T t) {
                child.onNext(t);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                try {
                    child.onError(e);
                }
                finally {
                    this.callAction();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                try {
                    child.onCompleted();
                }
                finally {
                    this.callAction();
                }
            }

            void callAction() {
                try {
                    OperatorDoAfterTerminate.this.action.call();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(ex);
                }
            }
        };
    }
}

