/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.functions.Func1;
import com.lambdaworks.rx.internal.util.UtilityFunctions;
import java.util.HashSet;
import java.util.Set;

public final class OperatorDistinct<T, U>
implements Observable.Operator<T, T> {
    final Func1<? super T, ? extends U> keySelector;

    public static <T> OperatorDistinct<T, T> instance() {
        return Holder.INSTANCE;
    }

    public OperatorDistinct(Func1<? super T, ? extends U> keySelector) {
        this.keySelector = keySelector;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){
            Set<U> keyMemory;
            {
                super(x0);
                this.keyMemory = new HashSet();
            }

            @Override
            public void onNext(T t) {
                Object key = OperatorDistinct.this.keySelector.call(t);
                if (this.keyMemory.add(key)) {
                    child.onNext(t);
                } else {
                    this.request(1L);
                }
            }

            @Override
            public void onError(Throwable e) {
                this.keyMemory = null;
                child.onError(e);
            }

            @Override
            public void onCompleted() {
                this.keyMemory = null;
                child.onCompleted();
            }
        };
    }

    private static class Holder {
        static final OperatorDistinct<?, ?> INSTANCE = new OperatorDistinct(UtilityFunctions.identity());

        private Holder() {
        }
    }
}

