/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.functions.Func1;
import com.lambdaworks.rx.observers.SerializedSubscriber;
import com.lambdaworks.rx.observers.Subscribers;
import com.lambdaworks.rx.subjects.PublishSubject;

public final class OperatorDelayWithSelector<T, V>
implements Observable.Operator<T, T> {
    final Observable<? extends T> source;
    final Func1<? super T, ? extends Observable<V>> itemDelay;

    public OperatorDelayWithSelector(Observable<? extends T> source, Func1<? super T, ? extends Observable<V>> itemDelay) {
        this.source = source;
        this.itemDelay = itemDelay;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> _child) {
        final SerializedSubscriber<? super T> child = new SerializedSubscriber<T>(_child);
        final PublishSubject delayedEmissions = PublishSubject.create();
        _child.add(Observable.merge(delayedEmissions).unsafeSubscribe(Subscribers.from(child)));
        return new Subscriber<T>(_child){

            @Override
            public void onCompleted() {
                delayedEmissions.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onNext(final T t) {
                try {
                    delayedEmissions.onNext(OperatorDelayWithSelector.this.itemDelay.call(t).take(1).defaultIfEmpty(null).map(new Func1<V, T>(){

                        @Override
                        public T call(V v) {
                            return t;
                        }
                    }));
                }
                catch (Throwable e) {
                    Exceptions.throwOrReport(e, this);
                }
            }
        };
    }
}

