/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Scheduler;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.functions.Action0;
import com.lambdaworks.rx.observers.SerializedSubscriber;
import com.lambdaworks.rx.subscriptions.SerialSubscription;
import java.util.concurrent.TimeUnit;

public final class OperatorDebounceWithTime<T>
implements Observable.Operator<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;

    public OperatorDebounceWithTime(long timeout, TimeUnit unit, Scheduler scheduler) {
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final Scheduler.Worker worker = this.scheduler.createWorker();
        final SerializedSubscriber<T> s = new SerializedSubscriber<T>(child);
        final SerialSubscription ssub = new SerialSubscription();
        s.add(worker);
        s.add(ssub);
        return new Subscriber<T>(child){
            final DebounceState<T> state;
            final Subscriber<?> self;
            {
                super(x0);
                this.state = new DebounceState();
                this.self = this;
            }

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(T t) {
                final int index = this.state.next(t);
                ssub.set(worker.schedule(new Action0(){

                    @Override
                    public void call() {
                        state.emit(index, s, self);
                    }
                }, OperatorDebounceWithTime.this.timeout, OperatorDebounceWithTime.this.unit));
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                this.unsubscribe();
                this.state.clear();
            }

            @Override
            public void onCompleted() {
                this.state.emitAndComplete(s, this);
            }
        };
    }

    static final class DebounceState<T> {
        int index;
        T value;
        boolean hasValue;
        boolean terminate;
        boolean emitting;

        DebounceState() {
        }

        public synchronized int next(T value) {
            this.value = value;
            this.hasValue = true;
            return ++this.index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void emit(int index, Subscriber<T> onNextAndComplete, Subscriber<?> onError) {
            T localValue;
            DebounceState debounceState = this;
            synchronized (debounceState) {
                if (this.emitting || !this.hasValue || index != this.index) {
                    return;
                }
                localValue = this.value;
                this.value = null;
                this.hasValue = false;
                this.emitting = true;
            }
            try {
                onNextAndComplete.onNext(localValue);
            }
            catch (Throwable e) {
                Exceptions.throwOrReport(e, onError, localValue);
                return;
            }
            debounceState = this;
            synchronized (debounceState) {
                if (!this.terminate) {
                    this.emitting = false;
                    return;
                }
            }
            onNextAndComplete.onCompleted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void emitAndComplete(Subscriber<T> onNextAndComplete, Subscriber<?> onError) {
            boolean localHasValue;
            T localValue;
            DebounceState debounceState = this;
            synchronized (debounceState) {
                if (this.emitting) {
                    this.terminate = true;
                    return;
                }
                localValue = this.value;
                localHasValue = this.hasValue;
                this.value = null;
                this.hasValue = false;
                this.emitting = true;
            }
            if (localHasValue) {
                try {
                    onNextAndComplete.onNext(localValue);
                }
                catch (Throwable e) {
                    Exceptions.throwOrReport(e, onError, localValue);
                    return;
                }
            }
            onNextAndComplete.onCompleted();
        }

        public synchronized void clear() {
            ++this.index;
            this.value = null;
            this.hasValue = false;
        }
    }
}

