/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.functions.Func1;
import com.lambdaworks.rx.internal.operators.OperatorDebounceWithTime;
import com.lambdaworks.rx.observers.SerializedSubscriber;
import com.lambdaworks.rx.subscriptions.SerialSubscription;

public final class OperatorDebounceWithSelector<T, U>
implements Observable.Operator<T, T> {
    final Func1<? super T, ? extends Observable<U>> selector;

    public OperatorDebounceWithSelector(Func1<? super T, ? extends Observable<U>> selector) {
        this.selector = selector;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        final SerialSubscription ssub = new SerialSubscription();
        child.add(ssub);
        return new Subscriber<T>(child){
            final OperatorDebounceWithTime.DebounceState<T> state;
            final Subscriber<?> self;
            {
                super(x0);
                this.state = new OperatorDebounceWithTime.DebounceState();
                this.self = this;
            }

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(T t) {
                Observable debouncer;
                try {
                    debouncer = OperatorDebounceWithSelector.this.selector.call(t);
                }
                catch (Throwable e) {
                    Exceptions.throwOrReport(e, this);
                    return;
                }
                final int index = this.state.next(t);
                Subscriber debounceSubscriber = new Subscriber<U>(){

                    @Override
                    public void onNext(U t) {
                        this.onCompleted();
                    }

                    @Override
                    public void onError(Throwable e) {
                        self.onError(e);
                    }

                    @Override
                    public void onCompleted() {
                        state.emit(index, s, self);
                        this.unsubscribe();
                    }
                };
                ssub.set(debounceSubscriber);
                debouncer.unsafeSubscribe(debounceSubscriber);
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                this.unsubscribe();
                this.state.clear();
            }

            @Override
            public void onCompleted() {
                this.state.emitAndComplete(s, this);
            }
        };
    }
}

