/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Scheduler;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.functions.Action0;
import com.lambdaworks.rx.observers.SerializedSubscriber;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class OperatorBufferWithTime<T>
implements Observable.Operator<List<T>, T> {
    final long timespan;
    final long timeshift;
    final TimeUnit unit;
    final int count;
    final Scheduler scheduler;

    public OperatorBufferWithTime(long timespan, long timeshift, TimeUnit unit, int count, Scheduler scheduler) {
        this.timespan = timespan;
        this.timeshift = timeshift;
        this.unit = unit;
        this.count = count;
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super List<T>> child) {
        Scheduler.Worker inner = this.scheduler.createWorker();
        SerializedSubscriber<? super List<T>> serialized = new SerializedSubscriber<List<T>>(child);
        if (this.timespan == this.timeshift) {
            ExactSubscriber bsub = new ExactSubscriber(serialized, inner);
            bsub.add(inner);
            child.add(bsub);
            bsub.scheduleExact();
            return bsub;
        }
        InexactSubscriber bsub = new InexactSubscriber(serialized, inner);
        bsub.add(inner);
        child.add(bsub);
        bsub.startNewChunk();
        bsub.scheduleChunk();
        return bsub;
    }

    final class ExactSubscriber
    extends Subscriber<T> {
        final Subscriber<? super List<T>> child;
        final Scheduler.Worker inner;
        List<T> chunk;
        boolean done;

        public ExactSubscriber(Subscriber<? super List<T>> child, Scheduler.Worker inner) {
            this.child = child;
            this.inner = inner;
            this.chunk = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            List toEmit = null;
            ExactSubscriber exactSubscriber = this;
            synchronized (exactSubscriber) {
                if (this.done) {
                    return;
                }
                this.chunk.add(t);
                if (this.chunk.size() == OperatorBufferWithTime.this.count) {
                    toEmit = this.chunk;
                    this.chunk = new ArrayList();
                }
            }
            if (toEmit != null) {
                this.child.onNext(toEmit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            ExactSubscriber exactSubscriber = this;
            synchronized (exactSubscriber) {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.chunk = null;
            }
            this.child.onError(e);
            this.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            try {
                List toEmit;
                this.inner.unsubscribe();
                ExactSubscriber exactSubscriber = this;
                synchronized (exactSubscriber) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    toEmit = this.chunk;
                    this.chunk = null;
                }
                this.child.onNext(toEmit);
            }
            catch (Throwable t) {
                Exceptions.throwOrReport(t, this.child);
                return;
            }
            this.child.onCompleted();
            this.unsubscribe();
        }

        void scheduleExact() {
            this.inner.schedulePeriodically(new Action0(){

                @Override
                public void call() {
                    ExactSubscriber.this.emit();
                }
            }, OperatorBufferWithTime.this.timespan, OperatorBufferWithTime.this.timespan, OperatorBufferWithTime.this.unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emit() {
            List toEmit;
            ExactSubscriber exactSubscriber = this;
            synchronized (exactSubscriber) {
                if (this.done) {
                    return;
                }
                toEmit = this.chunk;
                this.chunk = new ArrayList();
            }
            try {
                this.child.onNext(toEmit);
            }
            catch (Throwable t) {
                Exceptions.throwOrReport(t, this);
            }
        }
    }

    final class InexactSubscriber
    extends Subscriber<T> {
        final Subscriber<? super List<T>> child;
        final Scheduler.Worker inner;
        final List<List<T>> chunks;
        boolean done;

        public InexactSubscriber(Subscriber<? super List<T>> child, Scheduler.Worker inner) {
            this.child = child;
            this.inner = inner;
            this.chunks = new LinkedList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            LinkedList sizeReached = null;
            InexactSubscriber inexactSubscriber = this;
            synchronized (inexactSubscriber) {
                if (this.done) {
                    return;
                }
                Iterator iterator = this.chunks.iterator();
                while (iterator.hasNext()) {
                    List chunk = iterator.next();
                    chunk.add(t);
                    if (chunk.size() != OperatorBufferWithTime.this.count) continue;
                    iterator.remove();
                    if (sizeReached == null) {
                        sizeReached = new LinkedList();
                    }
                    sizeReached.add(chunk);
                }
            }
            if (sizeReached != null) {
                for (List list : sizeReached) {
                    this.child.onNext(list);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            InexactSubscriber inexactSubscriber = this;
            synchronized (inexactSubscriber) {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.chunks.clear();
            }
            this.child.onError(e);
            this.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            try {
                LinkedList sizeReached;
                InexactSubscriber inexactSubscriber = this;
                synchronized (inexactSubscriber) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    sizeReached = new LinkedList(this.chunks);
                    this.chunks.clear();
                }
                for (List list : sizeReached) {
                    this.child.onNext(list);
                }
            }
            catch (Throwable t) {
                Exceptions.throwOrReport(t, this.child);
                return;
            }
            this.child.onCompleted();
            this.unsubscribe();
        }

        void scheduleChunk() {
            this.inner.schedulePeriodically(new Action0(){

                @Override
                public void call() {
                    InexactSubscriber.this.startNewChunk();
                }
            }, OperatorBufferWithTime.this.timeshift, OperatorBufferWithTime.this.timeshift, OperatorBufferWithTime.this.unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startNewChunk() {
            final ArrayList chunk = new ArrayList();
            InexactSubscriber inexactSubscriber = this;
            synchronized (inexactSubscriber) {
                if (this.done) {
                    return;
                }
                this.chunks.add(chunk);
            }
            this.inner.schedule(new Action0(){

                @Override
                public void call() {
                    InexactSubscriber.this.emitChunk(chunk);
                }
            }, OperatorBufferWithTime.this.timespan, OperatorBufferWithTime.this.unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitChunk(List<T> chunkToEmit) {
            boolean emit = false;
            InexactSubscriber inexactSubscriber = this;
            synchronized (inexactSubscriber) {
                if (this.done) {
                    return;
                }
                Iterator it = this.chunks.iterator();
                while (it.hasNext()) {
                    List chunk = it.next();
                    if (chunk != chunkToEmit) continue;
                    it.remove();
                    emit = true;
                    break;
                }
            }
            if (emit) {
                try {
                    this.child.onNext(chunkToEmit);
                }
                catch (Throwable t) {
                    Exceptions.throwOrReport(t, this);
                }
            }
        }
    }
}

