/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Observer;
import com.lambdaworks.rx.Producer;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.Subscription;
import com.lambdaworks.rx.exceptions.MissingBackpressureException;
import com.lambdaworks.rx.internal.operators.BackpressureUtils;
import com.lambdaworks.rx.internal.util.atomic.SpscAtomicArrayQueue;
import com.lambdaworks.rx.internal.util.unsafe.SpscArrayQueue;
import com.lambdaworks.rx.internal.util.unsafe.UnsafeAccess;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class OnSubscribePublishMulticast<T>
extends AtomicInteger
implements Observable.OnSubscribe<T>,
Observer<T>,
Subscription {
    private static final long serialVersionUID = -3741892510772238743L;
    final Queue<T> queue;
    final int prefetch;
    final boolean delayError;
    final ParentSubscriber<T> parent;
    volatile boolean done;
    Throwable error;
    volatile Producer producer;
    volatile PublishProducer<T>[] subscribers;
    static final PublishProducer<?>[] EMPTY = new PublishProducer[0];
    static final PublishProducer<?>[] TERMINATED = new PublishProducer[0];

    public OnSubscribePublishMulticast(int prefetch, boolean delayError) {
        if (prefetch <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        this.prefetch = prefetch;
        this.delayError = delayError;
        this.queue = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue<T>(prefetch) : new SpscAtomicArrayQueue<T>(prefetch);
        this.subscribers = EMPTY;
        this.parent = new ParentSubscriber(this);
    }

    @Override
    public void call(Subscriber<? super T> t) {
        PublishProducer<T> pp = new PublishProducer<T>(t, this);
        t.add(pp);
        t.setProducer(pp);
        if (this.add(pp)) {
            if (pp.isUnsubscribed()) {
                this.remove(pp);
            } else {
                this.drain();
            }
        } else {
            Throwable e = this.error;
            if (e != null) {
                t.onError(e);
            } else {
                t.onCompleted();
            }
        }
    }

    @Override
    public void onNext(T t) {
        if (!this.queue.offer(t)) {
            this.parent.unsubscribe();
            this.error = new MissingBackpressureException("Queue full?!");
            this.done = true;
        }
        this.drain();
    }

    @Override
    public void onError(Throwable e) {
        this.error = e;
        this.done = true;
        this.drain();
    }

    @Override
    public void onCompleted() {
        this.done = true;
        this.drain();
    }

    void setProducer(Producer p) {
        this.producer = p;
        p.request(this.prefetch);
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        Queue<T> q = this.queue;
        int missed = 0;
        do {
            long e;
            long r = Long.MAX_VALUE;
            PublishProducer<T>[] a = this.subscribers;
            int n = a.length;
            for (PublishProducer<T> inner : a) {
                r = Math.min(r, inner.get());
            }
            if (n == 0) continue;
            for (e = 0L; e != r; ++e) {
                boolean empty;
                boolean d = this.done;
                T v = q.poll();
                boolean bl = empty = v == null;
                if (this.checkTerminated(d, empty)) {
                    return;
                }
                if (empty) break;
                for (PublishProducer<T> inner : a) {
                    inner.actual.onNext(v);
                }
            }
            if (e == r && this.checkTerminated(this.done, q.isEmpty())) {
                return;
            }
            if (e == 0L) continue;
            Producer p = this.producer;
            if (p != null) {
                p.request(e);
            }
            for (PublishProducer<T> inner : a) {
                BackpressureUtils.produced(inner, e);
            }
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    boolean checkTerminated(boolean d, boolean empty) {
        if (d) {
            if (this.delayError) {
                if (empty) {
                    PublishProducer<T>[] a = this.terminate();
                    Throwable ex = this.error;
                    if (ex != null) {
                        for (PublishProducer<T> inner : a) {
                            inner.actual.onError(ex);
                        }
                    } else {
                        for (PublishProducer<T> inner : a) {
                            inner.actual.onCompleted();
                        }
                    }
                    return true;
                }
            } else {
                Throwable ex = this.error;
                if (ex != null) {
                    PublishProducer<T>[] a;
                    this.queue.clear();
                    for (PublishProducer<T> inner : a = this.terminate()) {
                        inner.actual.onError(ex);
                    }
                    return true;
                }
                if (empty) {
                    PublishProducer<T>[] a;
                    for (PublishProducer<T> inner : a = this.terminate()) {
                        inner.actual.onCompleted();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PublishProducer<T>[] terminate() {
        PublishProducer<T>[] a = this.subscribers;
        if (a != TERMINATED) {
            OnSubscribePublishMulticast onSubscribePublishMulticast = this;
            synchronized (onSubscribePublishMulticast) {
                a = this.subscribers;
                if (a != TERMINATED) {
                    this.subscribers = TERMINATED;
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(PublishProducer<T> inner) {
        PublishProducer<T>[] a = this.subscribers;
        if (a == TERMINATED) {
            return false;
        }
        OnSubscribePublishMulticast onSubscribePublishMulticast = this;
        synchronized (onSubscribePublishMulticast) {
            a = this.subscribers;
            if (a == TERMINATED) {
                return false;
            }
            int n = a.length;
            PublishProducer[] b = new PublishProducer[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
            this.subscribers = b;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(PublishProducer<T> inner) {
        PublishProducer<T>[] a = this.subscribers;
        if (a == TERMINATED || a == EMPTY) {
            return;
        }
        OnSubscribePublishMulticast onSubscribePublishMulticast = this;
        synchronized (onSubscribePublishMulticast) {
            PublishProducer<?>[] b;
            a = this.subscribers;
            if (a == TERMINATED || a == EMPTY) {
                return;
            }
            int j = -1;
            int n = a.length;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
            } else {
                b = new PublishProducer[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            }
            this.subscribers = b;
        }
    }

    public Subscriber<T> subscriber() {
        return this.parent;
    }

    @Override
    public void unsubscribe() {
        this.parent.unsubscribe();
    }

    @Override
    public boolean isUnsubscribed() {
        return this.parent.isUnsubscribed();
    }

    static final class PublishProducer<T>
    extends AtomicLong
    implements Producer,
    Subscription {
        private static final long serialVersionUID = 960704844171597367L;
        final Subscriber<? super T> actual;
        final OnSubscribePublishMulticast<T> parent;
        final AtomicBoolean once;

        public PublishProducer(Subscriber<? super T> actual, OnSubscribePublishMulticast<T> parent) {
            this.actual = actual;
            this.parent = parent;
            this.once = new AtomicBoolean();
        }

        @Override
        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required but it was " + n);
            }
            if (n != 0L) {
                BackpressureUtils.getAndAddRequest(this, n);
                this.parent.drain();
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.once.get();
        }

        @Override
        public void unsubscribe() {
            if (this.once.compareAndSet(false, true)) {
                this.parent.remove(this);
            }
        }
    }

    static final class ParentSubscriber<T>
    extends Subscriber<T> {
        final OnSubscribePublishMulticast<T> state;

        public ParentSubscriber(OnSubscribePublishMulticast<T> state) {
            this.state = state;
        }

        @Override
        public void onNext(T t) {
            this.state.onNext(t);
        }

        @Override
        public void onError(Throwable e) {
            this.state.onError(e);
        }

        @Override
        public void onCompleted() {
            this.state.onCompleted();
        }

        @Override
        public void setProducer(Producer p) {
            this.state.setProducer(p);
        }
    }
}

