/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.plugins.RxJavaObservableExecutionHook;
import com.lambdaworks.rx.plugins.RxJavaPlugins;

public final class OnSubscribeLift<T, R>
implements Observable.OnSubscribe<R> {
    static final RxJavaObservableExecutionHook hook = RxJavaPlugins.getInstance().getObservableExecutionHook();
    final Observable.OnSubscribe<T> parent;
    final Observable.Operator<? extends R, ? super T> operator;

    public OnSubscribeLift(Observable.OnSubscribe<T> parent, Observable.Operator<? extends R, ? super T> operator) {
        this.parent = parent;
        this.operator = operator;
    }

    @Override
    public void call(Subscriber<? super R> o) {
        try {
            Subscriber st = (Subscriber)hook.onLift(this.operator).call(o);
            try {
                st.onStart();
                this.parent.call(st);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                st.onError(e);
            }
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            o.onError(e);
        }
    }
}

