/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.internal.operators;

import com.lambdaworks.rx.Completable;
import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.Subscription;
import com.lambdaworks.rx.exceptions.CompositeException;
import com.lambdaworks.rx.plugins.RxJavaPlugins;
import com.lambdaworks.rx.subscriptions.CompositeSubscription;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableOnSubscribeMerge
implements Completable.CompletableOnSubscribe {
    final Observable<Completable> source;
    final int maxConcurrency;
    final boolean delayErrors;

    public CompletableOnSubscribeMerge(Observable<? extends Completable> source, int maxConcurrency, boolean delayErrors) {
        this.source = source;
        this.maxConcurrency = maxConcurrency;
        this.delayErrors = delayErrors;
    }

    @Override
    public void call(Completable.CompletableSubscriber s) {
        CompletableMergeSubscriber parent = new CompletableMergeSubscriber(s, this.maxConcurrency, this.delayErrors);
        s.onSubscribe(parent);
        this.source.subscribe(parent);
    }

    public static Throwable collectErrors(Queue<Throwable> q) {
        Throwable t;
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while ((t = q.poll()) != null) {
            list.add(t);
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (Throwable)list.get(0);
        }
        return new CompositeException(list);
    }

    static final class CompletableMergeSubscriber
    extends Subscriber<Completable> {
        final Completable.CompletableSubscriber actual;
        final CompositeSubscription set;
        final int maxConcurrency;
        final boolean delayErrors;
        volatile boolean done;
        final AtomicReference<Queue<Throwable>> errors;
        final AtomicBoolean once;
        final AtomicInteger wip;

        public CompletableMergeSubscriber(Completable.CompletableSubscriber actual, int maxConcurrency, boolean delayErrors) {
            this.actual = actual;
            this.maxConcurrency = maxConcurrency;
            this.delayErrors = delayErrors;
            this.set = new CompositeSubscription();
            this.wip = new AtomicInteger(1);
            this.once = new AtomicBoolean();
            this.errors = new AtomicReference();
            if (maxConcurrency == Integer.MAX_VALUE) {
                this.request(Long.MAX_VALUE);
            } else {
                this.request(maxConcurrency);
            }
        }

        Queue<Throwable> getOrCreateErrors() {
            Queue<Throwable> q = this.errors.get();
            if (q != null) {
                return q;
            }
            q = new ConcurrentLinkedQueue<Throwable>();
            if (this.errors.compareAndSet(null, q)) {
                return q;
            }
            return this.errors.get();
        }

        @Override
        public void onNext(Completable t) {
            if (this.done) {
                return;
            }
            this.wip.getAndIncrement();
            t.unsafeSubscribe(new Completable.CompletableSubscriber(){
                Subscription d;
                boolean innerDone;

                @Override
                public void onSubscribe(Subscription d) {
                    this.d = d;
                    CompletableMergeSubscriber.this.set.add(d);
                }

                @Override
                public void onError(Throwable e) {
                    if (this.innerDone) {
                        RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                        return;
                    }
                    this.innerDone = true;
                    CompletableMergeSubscriber.this.set.remove(this.d);
                    CompletableMergeSubscriber.this.getOrCreateErrors().offer(e);
                    CompletableMergeSubscriber.this.terminate();
                    if (CompletableMergeSubscriber.this.delayErrors && !CompletableMergeSubscriber.this.done) {
                        CompletableMergeSubscriber.this.request(1L);
                    }
                }

                @Override
                public void onCompleted() {
                    if (this.innerDone) {
                        return;
                    }
                    this.innerDone = true;
                    CompletableMergeSubscriber.this.set.remove(this.d);
                    CompletableMergeSubscriber.this.terminate();
                    if (!CompletableMergeSubscriber.this.done) {
                        CompletableMergeSubscriber.this.request(1L);
                    }
                }
            });
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.getInstance().getErrorHandler().handleError(t);
                return;
            }
            this.getOrCreateErrors().offer(t);
            this.done = true;
            this.terminate();
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.terminate();
        }

        void terminate() {
            Queue<Throwable> q;
            if (this.wip.decrementAndGet() == 0) {
                Queue<Throwable> q2 = this.errors.get();
                if (q2 == null || q2.isEmpty()) {
                    this.actual.onCompleted();
                } else {
                    Throwable e = CompletableOnSubscribeMerge.collectErrors(q2);
                    if (this.once.compareAndSet(false, true)) {
                        this.actual.onError(e);
                    } else {
                        RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                    }
                }
            } else if (!this.delayErrors && (q = this.errors.get()) != null && !q.isEmpty()) {
                Throwable e = CompletableOnSubscribeMerge.collectErrors(q);
                if (this.once.compareAndSet(false, true)) {
                    this.actual.onError(e);
                } else {
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                }
            }
        }
    }
}

