/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx.exceptions;

import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.plugins.RxJavaPlugins;
import java.util.HashSet;
import java.util.Set;

public final class OnErrorThrowable
extends RuntimeException {
    private static final long serialVersionUID = -569558213262703934L;
    private final boolean hasValue;
    private final Object value;

    private OnErrorThrowable(Throwable exception) {
        super(exception);
        this.hasValue = false;
        this.value = null;
    }

    private OnErrorThrowable(Throwable exception, Object value) {
        super(exception);
        this.hasValue = true;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isValueNull() {
        return this.hasValue;
    }

    public static OnErrorThrowable from(Throwable t) {
        Throwable cause;
        if (t == null) {
            t = new NullPointerException();
        }
        if ((cause = Exceptions.getFinalCause(t)) instanceof OnNextValue) {
            return new OnErrorThrowable(t, ((OnNextValue)cause).getValue());
        }
        return new OnErrorThrowable(t);
    }

    public static Throwable addValueAsLastCause(Throwable e, Object value) {
        Throwable lastCause;
        if (e == null) {
            e = new NullPointerException();
        }
        if ((lastCause = Exceptions.getFinalCause(e)) != null && lastCause instanceof OnNextValue && ((OnNextValue)lastCause).getValue() == value) {
            return e;
        }
        Exceptions.addCause(e, new OnNextValue(value));
        return e;
    }

    public static class OnNextValue
    extends RuntimeException {
        private static final long serialVersionUID = -3454462756050397899L;
        private final Object value;

        public OnNextValue(Object value) {
            super("OnError while emitting onNext value: " + OnNextValue.renderValue(value));
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        static String renderValue(Object value) {
            if (value == null) {
                return "null";
            }
            if (Primitives.INSTANCE.contains(value.getClass())) {
                return value.toString();
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Enum) {
                return ((Enum)value).name();
            }
            String pluggedRendering = RxJavaPlugins.getInstance().getErrorHandler().handleOnNextValueRendering(value);
            if (pluggedRendering != null) {
                return pluggedRendering;
            }
            return value.getClass().getName() + ".class";
        }

        private static final class Primitives {
            static final Set<Class<?>> INSTANCE = Primitives.create();

            private Primitives() {
            }

            private static Set<Class<?>> create() {
                HashSet set = new HashSet();
                set.add(Boolean.class);
                set.add(Character.class);
                set.add(Byte.class);
                set.add(Short.class);
                set.add(Integer.class);
                set.add(Long.class);
                set.add(Float.class);
                set.add(Double.class);
                return set;
            }
        }
    }
}

