/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx;

import com.lambdaworks.rx.Subscription;
import com.lambdaworks.rx.functions.Action0;
import com.lambdaworks.rx.subscriptions.MultipleAssignmentSubscription;
import java.util.concurrent.TimeUnit;

public abstract class Scheduler {
    static final long CLOCK_DRIFT_TOLERANCE_NANOS = TimeUnit.MINUTES.toNanos(Long.getLong("com.lambdaworks.rx.scheduler.drift-tolerance", 15L));

    public abstract Worker createWorker();

    public long now() {
        return System.currentTimeMillis();
    }

    public static abstract class Worker
    implements Subscription {
        public abstract Subscription schedule(Action0 var1);

        public abstract Subscription schedule(Action0 var1, long var2, TimeUnit var4);

        public Subscription schedulePeriodically(final Action0 action, long initialDelay, long period, TimeUnit unit) {
            final long periodInNanos = unit.toNanos(period);
            final long firstNowNanos = TimeUnit.MILLISECONDS.toNanos(this.now());
            final long firstStartInNanos = firstNowNanos + unit.toNanos(initialDelay);
            final MultipleAssignmentSubscription mas = new MultipleAssignmentSubscription();
            Action0 recursiveAction = new Action0(){
                long count;
                long lastNowNanos;
                long startInNanos;
                {
                    this.lastNowNanos = firstNowNanos;
                    this.startInNanos = firstStartInNanos;
                }

                @Override
                public void call() {
                    if (!mas.isUnsubscribed()) {
                        long nextTick;
                        action.call();
                        long nowNanos = TimeUnit.MILLISECONDS.toNanos(Worker.this.now());
                        if (nowNanos + CLOCK_DRIFT_TOLERANCE_NANOS < this.lastNowNanos || nowNanos >= this.lastNowNanos + periodInNanos + CLOCK_DRIFT_TOLERANCE_NANOS) {
                            nextTick = nowNanos + periodInNanos;
                            this.startInNanos = nextTick - periodInNanos * ++this.count;
                        } else {
                            nextTick = this.startInNanos + ++this.count * periodInNanos;
                        }
                        this.lastNowNanos = nowNanos;
                        long delay = nextTick - nowNanos;
                        mas.set(Worker.this.schedule(this, delay, TimeUnit.NANOSECONDS));
                    }
                }
            };
            MultipleAssignmentSubscription s = new MultipleAssignmentSubscription();
            mas.set(s);
            s.set(this.schedule(recursiveAction, initialDelay, unit));
            return mas;
        }

        public long now() {
            return System.currentTimeMillis();
        }
    }
}

