/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx;

import com.lambdaworks.rx.Observable;
import com.lambdaworks.rx.Scheduler;
import com.lambdaworks.rx.Single;
import com.lambdaworks.rx.SingleSubscriber;
import com.lambdaworks.rx.Subscriber;
import com.lambdaworks.rx.Subscription;
import com.lambdaworks.rx.annotations.Experimental;
import com.lambdaworks.rx.exceptions.CompositeException;
import com.lambdaworks.rx.exceptions.Exceptions;
import com.lambdaworks.rx.functions.Action0;
import com.lambdaworks.rx.functions.Action1;
import com.lambdaworks.rx.functions.Actions;
import com.lambdaworks.rx.functions.Func0;
import com.lambdaworks.rx.functions.Func1;
import com.lambdaworks.rx.functions.Func2;
import com.lambdaworks.rx.internal.operators.CompletableOnSubscribeConcat;
import com.lambdaworks.rx.internal.operators.CompletableOnSubscribeConcatArray;
import com.lambdaworks.rx.internal.operators.CompletableOnSubscribeConcatIterable;
import com.lambdaworks.rx.internal.operators.CompletableOnSubscribeMerge;
import com.lambdaworks.rx.internal.operators.CompletableOnSubscribeMergeArray;
import com.lambdaworks.rx.internal.operators.CompletableOnSubscribeMergeDelayErrorArray;
import com.lambdaworks.rx.internal.operators.CompletableOnSubscribeMergeDelayErrorIterable;
import com.lambdaworks.rx.internal.operators.CompletableOnSubscribeMergeIterable;
import com.lambdaworks.rx.internal.operators.CompletableOnSubscribeTimeout;
import com.lambdaworks.rx.internal.util.SubscriptionList;
import com.lambdaworks.rx.internal.util.UtilityFunctions;
import com.lambdaworks.rx.observers.SafeCompletableSubscriber;
import com.lambdaworks.rx.observers.SafeSubscriber;
import com.lambdaworks.rx.plugins.RxJavaCompletableExecutionHook;
import com.lambdaworks.rx.plugins.RxJavaErrorHandler;
import com.lambdaworks.rx.plugins.RxJavaPlugins;
import com.lambdaworks.rx.schedulers.Schedulers;
import com.lambdaworks.rx.subscriptions.BooleanSubscription;
import com.lambdaworks.rx.subscriptions.CompositeSubscription;
import com.lambdaworks.rx.subscriptions.MultipleAssignmentSubscription;
import com.lambdaworks.rx.subscriptions.SerialSubscription;
import com.lambdaworks.rx.subscriptions.Subscriptions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

@Experimental
public class Completable {
    static final RxJavaErrorHandler ERROR_HANDLER = RxJavaPlugins.getInstance().getErrorHandler();
    static RxJavaCompletableExecutionHook HOOK = RxJavaPlugins.getInstance().getCompletableExecutionHook();
    static final Completable COMPLETE = Completable.create(new CompletableOnSubscribe(){

        @Override
        public void call(CompletableSubscriber s) {
            s.onSubscribe(Subscriptions.unsubscribed());
            s.onCompleted();
        }
    });
    static final Completable NEVER = Completable.create(new CompletableOnSubscribe(){

        @Override
        public void call(CompletableSubscriber s) {
            s.onSubscribe(Subscriptions.unsubscribed());
        }
    });
    private final CompletableOnSubscribe onSubscribe;

    public static Completable amb(final Completable ... sources) {
        Completable.requireNonNull(sources);
        if (sources.length == 0) {
            return Completable.complete();
        }
        if (sources.length == 1) {
            return sources[0];
        }
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s) {
                final CompositeSubscription set = new CompositeSubscription();
                s.onSubscribe(set);
                final AtomicBoolean once = new AtomicBoolean();
                CompletableSubscriber inner = new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        if (once.compareAndSet(false, true)) {
                            set.unsubscribe();
                            s.onCompleted();
                        }
                    }

                    @Override
                    public void onError(Throwable e) {
                        if (once.compareAndSet(false, true)) {
                            set.unsubscribe();
                            s.onError(e);
                        } else {
                            ERROR_HANDLER.handleError(e);
                        }
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        set.add(d);
                    }
                };
                for (Completable c : sources) {
                    if (set.isUnsubscribed()) {
                        return;
                    }
                    if (c == null) {
                        NullPointerException npe = new NullPointerException("One of the sources is null");
                        if (once.compareAndSet(false, true)) {
                            set.unsubscribe();
                            s.onError(npe);
                        } else {
                            ERROR_HANDLER.handleError(npe);
                        }
                        return;
                    }
                    if (once.get() || set.isUnsubscribed()) {
                        return;
                    }
                    c.unsafeSubscribe(inner);
                }
            }
        });
    }

    public static Completable amb(final Iterable<? extends Completable> sources) {
        Completable.requireNonNull(sources);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s) {
                Iterator it;
                final CompositeSubscription set = new CompositeSubscription();
                s.onSubscribe(set);
                final AtomicBoolean once = new AtomicBoolean();
                CompletableSubscriber inner = new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        if (once.compareAndSet(false, true)) {
                            set.unsubscribe();
                            s.onCompleted();
                        }
                    }

                    @Override
                    public void onError(Throwable e) {
                        if (once.compareAndSet(false, true)) {
                            set.unsubscribe();
                            s.onError(e);
                        } else {
                            ERROR_HANDLER.handleError(e);
                        }
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        set.add(d);
                    }
                };
                try {
                    it = sources.iterator();
                }
                catch (Throwable e) {
                    s.onError(e);
                    return;
                }
                if (it == null) {
                    s.onError(new NullPointerException("The iterator returned is null"));
                    return;
                }
                boolean empty = true;
                while (true) {
                    Completable c;
                    boolean b;
                    if (once.get() || set.isUnsubscribed()) {
                        return;
                    }
                    try {
                        b = it.hasNext();
                    }
                    catch (Throwable e) {
                        if (once.compareAndSet(false, true)) {
                            set.unsubscribe();
                            s.onError(e);
                        } else {
                            ERROR_HANDLER.handleError(e);
                        }
                        return;
                    }
                    if (!b) {
                        if (!empty) break;
                        s.onCompleted();
                        break;
                    }
                    empty = false;
                    if (once.get() || set.isUnsubscribed()) {
                        return;
                    }
                    try {
                        c = (Completable)it.next();
                    }
                    catch (Throwable e) {
                        if (once.compareAndSet(false, true)) {
                            set.unsubscribe();
                            s.onError(e);
                        } else {
                            ERROR_HANDLER.handleError(e);
                        }
                        return;
                    }
                    if (c == null) {
                        NullPointerException npe = new NullPointerException("One of the sources is null");
                        if (once.compareAndSet(false, true)) {
                            set.unsubscribe();
                            s.onError(npe);
                        } else {
                            ERROR_HANDLER.handleError(npe);
                        }
                        return;
                    }
                    if (once.get() || set.isUnsubscribed()) {
                        return;
                    }
                    c.unsafeSubscribe(inner);
                }
            }
        });
    }

    public static Completable complete() {
        return COMPLETE;
    }

    public static Completable concat(Completable ... sources) {
        Completable.requireNonNull(sources);
        if (sources.length == 0) {
            return Completable.complete();
        }
        if (sources.length == 1) {
            return sources[0];
        }
        return Completable.create(new CompletableOnSubscribeConcatArray(sources));
    }

    public static Completable concat(Iterable<? extends Completable> sources) {
        Completable.requireNonNull(sources);
        return Completable.create(new CompletableOnSubscribeConcatIterable(sources));
    }

    public static Completable concat(Observable<? extends Completable> sources) {
        return Completable.concat(sources, 2);
    }

    public static Completable concat(Observable<? extends Completable> sources, int prefetch) {
        Completable.requireNonNull(sources);
        if (prefetch < 1) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        return Completable.create(new CompletableOnSubscribeConcat(sources, prefetch));
    }

    public static Completable create(CompletableOnSubscribe onSubscribe) {
        Completable.requireNonNull(onSubscribe);
        try {
            return new Completable(onSubscribe);
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            ERROR_HANDLER.handleError(ex);
            throw Completable.toNpe(ex);
        }
    }

    public static Completable defer(final Func0<? extends Completable> completableFunc0) {
        Completable.requireNonNull(completableFunc0);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(CompletableSubscriber s) {
                Completable c;
                try {
                    c = (Completable)completableFunc0.call();
                }
                catch (Throwable e) {
                    s.onSubscribe(Subscriptions.unsubscribed());
                    s.onError(e);
                    return;
                }
                if (c == null) {
                    s.onSubscribe(Subscriptions.unsubscribed());
                    s.onError(new NullPointerException("The completable returned is null"));
                    return;
                }
                c.unsafeSubscribe(s);
            }
        });
    }

    public static Completable error(final Func0<? extends Throwable> errorFunc0) {
        Completable.requireNonNull(errorFunc0);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(CompletableSubscriber s) {
                Throwable error;
                s.onSubscribe(Subscriptions.unsubscribed());
                try {
                    error = (Throwable)errorFunc0.call();
                }
                catch (Throwable e) {
                    error = e;
                }
                if (error == null) {
                    error = new NullPointerException("The error supplied is null");
                }
                s.onError(error);
            }
        });
    }

    public static Completable error(final Throwable error) {
        Completable.requireNonNull(error);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(CompletableSubscriber s) {
                s.onSubscribe(Subscriptions.unsubscribed());
                s.onError(error);
            }
        });
    }

    public static Completable fromAction(final Action0 action) {
        Completable.requireNonNull(action);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(CompletableSubscriber s) {
                BooleanSubscription bs = new BooleanSubscription();
                s.onSubscribe(bs);
                try {
                    action.call();
                }
                catch (Throwable e) {
                    if (!bs.isUnsubscribed()) {
                        s.onError(e);
                    }
                    return;
                }
                if (!bs.isUnsubscribed()) {
                    s.onCompleted();
                }
            }
        });
    }

    public static Completable fromCallable(final Callable<?> callable) {
        Completable.requireNonNull(callable);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(CompletableSubscriber s) {
                BooleanSubscription bs = new BooleanSubscription();
                s.onSubscribe(bs);
                try {
                    callable.call();
                }
                catch (Throwable e) {
                    if (!bs.isUnsubscribed()) {
                        s.onError(e);
                    }
                    return;
                }
                if (!bs.isUnsubscribed()) {
                    s.onCompleted();
                }
            }
        });
    }

    public static Completable fromFuture(Future<?> future) {
        Completable.requireNonNull(future);
        return Completable.fromObservable(Observable.from(future));
    }

    public static Completable fromObservable(final Observable<?> flowable) {
        Completable.requireNonNull(flowable);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(final CompletableSubscriber cs) {
                Subscriber<Object> subscriber = new Subscriber<Object>(){

                    @Override
                    public void onCompleted() {
                        cs.onCompleted();
                    }

                    @Override
                    public void onError(Throwable t) {
                        cs.onError(t);
                    }

                    @Override
                    public void onNext(Object t) {
                    }
                };
                cs.onSubscribe(subscriber);
                flowable.unsafeSubscribe(subscriber);
            }
        });
    }

    public static Completable fromSingle(final Single<?> single) {
        Completable.requireNonNull(single);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s) {
                SingleSubscriber<Object> te = new SingleSubscriber<Object>(){

                    @Override
                    public void onError(Throwable e) {
                        s.onError(e);
                    }

                    @Override
                    public void onSuccess(Object value) {
                        s.onCompleted();
                    }
                };
                s.onSubscribe(te);
                single.subscribe(te);
            }
        });
    }

    public static Completable merge(Completable ... sources) {
        Completable.requireNonNull(sources);
        if (sources.length == 0) {
            return Completable.complete();
        }
        if (sources.length == 1) {
            return sources[0];
        }
        return Completable.create(new CompletableOnSubscribeMergeArray(sources));
    }

    public static Completable merge(Iterable<? extends Completable> sources) {
        Completable.requireNonNull(sources);
        return Completable.create(new CompletableOnSubscribeMergeIterable(sources));
    }

    public static Completable merge(Observable<? extends Completable> sources) {
        return Completable.merge0(sources, Integer.MAX_VALUE, false);
    }

    public static Completable merge(Observable<? extends Completable> sources, int maxConcurrency) {
        return Completable.merge0(sources, maxConcurrency, false);
    }

    protected static Completable merge0(Observable<? extends Completable> sources, int maxConcurrency, boolean delayErrors) {
        Completable.requireNonNull(sources);
        if (maxConcurrency < 1) {
            throw new IllegalArgumentException("maxConcurrency > 0 required but it was " + maxConcurrency);
        }
        return Completable.create(new CompletableOnSubscribeMerge(sources, maxConcurrency, delayErrors));
    }

    public static Completable mergeDelayError(Completable ... sources) {
        Completable.requireNonNull(sources);
        return Completable.create(new CompletableOnSubscribeMergeDelayErrorArray(sources));
    }

    public static Completable mergeDelayError(Iterable<? extends Completable> sources) {
        Completable.requireNonNull(sources);
        return Completable.create(new CompletableOnSubscribeMergeDelayErrorIterable(sources));
    }

    public static Completable mergeDelayError(Observable<? extends Completable> sources) {
        return Completable.merge0(sources, Integer.MAX_VALUE, true);
    }

    public static Completable mergeDelayError(Observable<? extends Completable> sources, int maxConcurrency) {
        return Completable.merge0(sources, maxConcurrency, true);
    }

    public static Completable never() {
        return NEVER;
    }

    static <T> T requireNonNull(T o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return o;
    }

    public static Completable timer(long delay, TimeUnit unit) {
        return Completable.timer(delay, unit, Schedulers.computation());
    }

    public static Completable timer(final long delay, final TimeUnit unit, final Scheduler scheduler) {
        Completable.requireNonNull(unit);
        Completable.requireNonNull(scheduler);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s) {
                MultipleAssignmentSubscription mad = new MultipleAssignmentSubscription();
                s.onSubscribe(mad);
                if (!mad.isUnsubscribed()) {
                    final Scheduler.Worker w = scheduler.createWorker();
                    mad.set(w);
                    w.schedule(new Action0(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void call() {
                            try {
                                s.onCompleted();
                            }
                            finally {
                                w.unsubscribe();
                            }
                        }
                    }, delay, unit);
                }
            }
        });
    }

    static NullPointerException toNpe(Throwable ex) {
        NullPointerException npe = new NullPointerException("Actually not, but can't pass out an exception otherwise...");
        npe.initCause(ex);
        return npe;
    }

    public static <R> Completable using(Func0<R> resourceFunc0, Func1<? super R, ? extends Completable> completableFunc1, Action1<? super R> disposer) {
        return Completable.using(resourceFunc0, completableFunc1, disposer, true);
    }

    public static <R> Completable using(final Func0<R> resourceFunc0, final Func1<? super R, ? extends Completable> completableFunc1, final Action1<? super R> disposer, final boolean eager) {
        Completable.requireNonNull(resourceFunc0);
        Completable.requireNonNull(completableFunc1);
        Completable.requireNonNull(disposer);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s) {
                Completable cs;
                Object resource;
                try {
                    resource = resourceFunc0.call();
                }
                catch (Throwable e) {
                    s.onSubscribe(Subscriptions.unsubscribed());
                    s.onError(e);
                    return;
                }
                try {
                    cs = (Completable)completableFunc1.call(resource);
                }
                catch (Throwable e) {
                    try {
                        disposer.call(resource);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(e);
                        Exceptions.throwIfFatal(ex);
                        s.onSubscribe(Subscriptions.unsubscribed());
                        s.onError(new CompositeException(Arrays.asList(e, ex)));
                        return;
                    }
                    Exceptions.throwIfFatal(e);
                    s.onSubscribe(Subscriptions.unsubscribed());
                    s.onError(e);
                    return;
                }
                if (cs == null) {
                    try {
                        disposer.call(resource);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        s.onSubscribe(Subscriptions.unsubscribed());
                        s.onError(new CompositeException(Arrays.asList(new NullPointerException("The completable supplied is null"), ex)));
                        return;
                    }
                    s.onSubscribe(Subscriptions.unsubscribed());
                    s.onError(new NullPointerException("The completable supplied is null"));
                    return;
                }
                final AtomicBoolean once = new AtomicBoolean();
                cs.unsafeSubscribe(new CompletableSubscriber(){
                    Subscription d;

                    void dispose() {
                        this.d.unsubscribe();
                        if (once.compareAndSet(false, true)) {
                            try {
                                disposer.call(resource);
                            }
                            catch (Throwable ex) {
                                ERROR_HANDLER.handleError(ex);
                            }
                        }
                    }

                    @Override
                    public void onCompleted() {
                        if (eager && once.compareAndSet(false, true)) {
                            try {
                                disposer.call(resource);
                            }
                            catch (Throwable ex) {
                                s.onError(ex);
                                return;
                            }
                        }
                        s.onCompleted();
                        if (!eager) {
                            this.dispose();
                        }
                    }

                    @Override
                    public void onError(Throwable e) {
                        if (eager && once.compareAndSet(false, true)) {
                            try {
                                disposer.call(resource);
                            }
                            catch (Throwable ex) {
                                e = new CompositeException(Arrays.asList(e, ex));
                            }
                        }
                        s.onError(e);
                        if (!eager) {
                            this.dispose();
                        }
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        this.d = d;
                        s.onSubscribe(Subscriptions.create(new Action0(){

                            @Override
                            public void call() {
                                this.dispose();
                            }
                        }));
                    }
                });
            }
        });
    }

    protected Completable(CompletableOnSubscribe onSubscribe) {
        this.onSubscribe = HOOK.onCreate(onSubscribe);
    }

    public final Completable ambWith(Completable other) {
        Completable.requireNonNull(other);
        return Completable.amb(this, other);
    }

    public final void await() {
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] err = new Throwable[1];
        this.unsafeSubscribe(new CompletableSubscriber(){

            @Override
            public void onCompleted() {
                cdl.countDown();
            }

            @Override
            public void onError(Throwable e) {
                err[0] = e;
                cdl.countDown();
            }

            @Override
            public void onSubscribe(Subscription d) {
            }
        });
        if (cdl.getCount() == 0L) {
            if (err[0] != null) {
                Exceptions.propagate(err[0]);
            }
            return;
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            throw Exceptions.propagate(ex);
        }
        if (err[0] != null) {
            Exceptions.propagate(err[0]);
        }
    }

    public final boolean await(long timeout, TimeUnit unit) {
        boolean b;
        Completable.requireNonNull(unit);
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] err = new Throwable[1];
        this.unsafeSubscribe(new CompletableSubscriber(){

            @Override
            public void onCompleted() {
                cdl.countDown();
            }

            @Override
            public void onError(Throwable e) {
                err[0] = e;
                cdl.countDown();
            }

            @Override
            public void onSubscribe(Subscription d) {
            }
        });
        if (cdl.getCount() == 0L) {
            if (err[0] != null) {
                Exceptions.propagate(err[0]);
            }
            return true;
        }
        try {
            b = cdl.await(timeout, unit);
        }
        catch (InterruptedException ex) {
            throw Exceptions.propagate(ex);
        }
        if (b && err[0] != null) {
            Exceptions.propagate(err[0]);
        }
        return b;
    }

    public final Completable compose(CompletableTransformer transformer) {
        return this.to(transformer);
    }

    public final <T> Observable<T> andThen(Observable<T> next) {
        Completable.requireNonNull(next);
        return next.delaySubscription(this.toObservable());
    }

    public final <T> Single<T> andThen(Single<T> next) {
        Completable.requireNonNull(next);
        return next.delaySubscription(this.toObservable());
    }

    public final Completable andThen(Completable next) {
        return this.concatWith(next);
    }

    public final Completable concatWith(Completable other) {
        Completable.requireNonNull(other);
        return Completable.concat(this, other);
    }

    public final Completable delay(long delay, TimeUnit unit) {
        return this.delay(delay, unit, Schedulers.computation(), false);
    }

    public final Completable delay(long delay, TimeUnit unit, Scheduler scheduler) {
        return this.delay(delay, unit, scheduler, false);
    }

    public final Completable delay(final long delay, final TimeUnit unit, final Scheduler scheduler, final boolean delayError) {
        Completable.requireNonNull(unit);
        Completable.requireNonNull(scheduler);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s) {
                final CompositeSubscription set = new CompositeSubscription();
                final Scheduler.Worker w = scheduler.createWorker();
                set.add(w);
                Completable.this.unsafeSubscribe(new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        set.add(w.schedule(new Action0(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void call() {
                                try {
                                    s.onCompleted();
                                }
                                finally {
                                    w.unsubscribe();
                                }
                            }
                        }, delay, unit));
                    }

                    @Override
                    public void onError(final Throwable e) {
                        if (delayError) {
                            set.add(w.schedule(new Action0(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void call() {
                                    try {
                                        s.onError(e);
                                    }
                                    finally {
                                        w.unsubscribe();
                                    }
                                }
                            }, delay, unit));
                        } else {
                            s.onError(e);
                        }
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        set.add(d);
                        s.onSubscribe(set);
                    }
                });
            }
        });
    }

    @Deprecated
    public final Completable doOnComplete(Action0 onComplete) {
        return this.doOnCompleted(onComplete);
    }

    public final Completable doOnCompleted(Action0 onCompleted) {
        return this.doOnLifecycle(Actions.empty(), Actions.empty(), onCompleted, Actions.empty(), Actions.empty());
    }

    public final Completable doOnUnsubscribe(Action0 onUnsubscribe) {
        return this.doOnLifecycle(Actions.empty(), Actions.empty(), Actions.empty(), Actions.empty(), onUnsubscribe);
    }

    public final Completable doOnError(Action1<? super Throwable> onError) {
        return this.doOnLifecycle(Actions.empty(), onError, Actions.empty(), Actions.empty(), Actions.empty());
    }

    protected final Completable doOnLifecycle(final Action1<? super Subscription> onSubscribe, final Action1<? super Throwable> onError, final Action0 onComplete, final Action0 onAfterComplete, final Action0 onUnsubscribe) {
        Completable.requireNonNull(onSubscribe);
        Completable.requireNonNull(onError);
        Completable.requireNonNull(onComplete);
        Completable.requireNonNull(onAfterComplete);
        Completable.requireNonNull(onUnsubscribe);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s) {
                Completable.this.unsafeSubscribe(new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        try {
                            onComplete.call();
                        }
                        catch (Throwable e) {
                            s.onError(e);
                            return;
                        }
                        s.onCompleted();
                        try {
                            onAfterComplete.call();
                        }
                        catch (Throwable e) {
                            ERROR_HANDLER.handleError(e);
                        }
                    }

                    @Override
                    public void onError(Throwable e) {
                        try {
                            onError.call(e);
                        }
                        catch (Throwable ex) {
                            e = new CompositeException(Arrays.asList(e, ex));
                        }
                        s.onError(e);
                    }

                    @Override
                    public void onSubscribe(final Subscription d) {
                        try {
                            onSubscribe.call(d);
                        }
                        catch (Throwable ex) {
                            d.unsubscribe();
                            s.onSubscribe(Subscriptions.unsubscribed());
                            s.onError(ex);
                            return;
                        }
                        s.onSubscribe(Subscriptions.create(new Action0(){

                            @Override
                            public void call() {
                                try {
                                    onUnsubscribe.call();
                                }
                                catch (Throwable e) {
                                    ERROR_HANDLER.handleError(e);
                                }
                                d.unsubscribe();
                            }
                        }));
                    }
                });
            }
        });
    }

    public final Completable doOnSubscribe(Action1<? super Subscription> onSubscribe) {
        return this.doOnLifecycle(onSubscribe, Actions.empty(), Actions.empty(), Actions.empty(), Actions.empty());
    }

    public final Completable doOnTerminate(final Action0 onTerminate) {
        return this.doOnLifecycle(Actions.empty(), (Action1<? super Throwable>)new Action1<Throwable>(){

            @Override
            public void call(Throwable e) {
                onTerminate.call();
            }
        }, onTerminate, Actions.empty(), Actions.empty());
    }

    @Deprecated
    public final Completable endWith(Completable other) {
        return this.andThen(other);
    }

    @Deprecated
    public final <T> Observable<T> endWith(Observable<T> next) {
        return this.andThen(next);
    }

    public final Completable doAfterTerminate(Action0 onAfterComplete) {
        return this.doOnLifecycle(Actions.empty(), Actions.empty(), Actions.empty(), onAfterComplete, Actions.empty());
    }

    public final Throwable get() {
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] err = new Throwable[1];
        this.unsafeSubscribe(new CompletableSubscriber(){

            @Override
            public void onCompleted() {
                cdl.countDown();
            }

            @Override
            public void onError(Throwable e) {
                err[0] = e;
                cdl.countDown();
            }

            @Override
            public void onSubscribe(Subscription d) {
            }
        });
        if (cdl.getCount() == 0L) {
            return err[0];
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            throw Exceptions.propagate(ex);
        }
        return err[0];
    }

    public final Throwable get(long timeout, TimeUnit unit) {
        boolean b;
        Completable.requireNonNull(unit);
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] err = new Throwable[1];
        this.unsafeSubscribe(new CompletableSubscriber(){

            @Override
            public void onCompleted() {
                cdl.countDown();
            }

            @Override
            public void onError(Throwable e) {
                err[0] = e;
                cdl.countDown();
            }

            @Override
            public void onSubscribe(Subscription d) {
            }
        });
        if (cdl.getCount() == 0L) {
            return err[0];
        }
        try {
            b = cdl.await(timeout, unit);
        }
        catch (InterruptedException ex) {
            throw Exceptions.propagate(ex);
        }
        if (b) {
            return err[0];
        }
        Exceptions.propagate(new TimeoutException());
        return null;
    }

    public final Completable lift(final CompletableOperator onLift) {
        Completable.requireNonNull(onLift);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(CompletableSubscriber s) {
                try {
                    CompletableOperator onLiftDecorated = HOOK.onLift(onLift);
                    CompletableSubscriber sw = (CompletableSubscriber)onLiftDecorated.call(s);
                    Completable.this.unsafeSubscribe(sw);
                }
                catch (NullPointerException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw Completable.toNpe(ex);
                }
            }
        });
    }

    public final Completable mergeWith(Completable other) {
        Completable.requireNonNull(other);
        return Completable.merge(this, other);
    }

    public final Completable observeOn(final Scheduler scheduler) {
        Completable.requireNonNull(scheduler);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s) {
                final SubscriptionList ad = new SubscriptionList();
                final Scheduler.Worker w = scheduler.createWorker();
                ad.add(w);
                s.onSubscribe(ad);
                Completable.this.unsafeSubscribe(new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        w.schedule(new Action0(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void call() {
                                try {
                                    s.onCompleted();
                                }
                                finally {
                                    ad.unsubscribe();
                                }
                            }
                        });
                    }

                    @Override
                    public void onError(final Throwable e) {
                        w.schedule(new Action0(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void call() {
                                try {
                                    s.onError(e);
                                }
                                finally {
                                    ad.unsubscribe();
                                }
                            }
                        });
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        ad.add(d);
                    }
                });
            }
        });
    }

    public final Completable onErrorComplete() {
        return this.onErrorComplete(UtilityFunctions.alwaysTrue());
    }

    public final Completable onErrorComplete(final Func1<? super Throwable, Boolean> predicate) {
        Completable.requireNonNull(predicate);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s) {
                Completable.this.unsafeSubscribe(new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        s.onCompleted();
                    }

                    @Override
                    public void onError(Throwable e) {
                        boolean b;
                        try {
                            b = (Boolean)predicate.call(e);
                        }
                        catch (Throwable ex) {
                            e = new CompositeException(Arrays.asList(e, ex));
                            return;
                        }
                        if (b) {
                            s.onCompleted();
                        } else {
                            s.onError(e);
                        }
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        s.onSubscribe(d);
                    }
                });
            }
        });
    }

    public final Completable onErrorResumeNext(final Func1<? super Throwable, ? extends Completable> errorMapper) {
        Completable.requireNonNull(errorMapper);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s) {
                final SerialSubscription sd = new SerialSubscription();
                Completable.this.unsafeSubscribe(new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        s.onCompleted();
                    }

                    @Override
                    public void onError(Throwable e) {
                        Completable c;
                        try {
                            c = (Completable)errorMapper.call(e);
                        }
                        catch (Throwable ex) {
                            e = new CompositeException(Arrays.asList(e, ex));
                            s.onError(e);
                            return;
                        }
                        if (c == null) {
                            NullPointerException npe = new NullPointerException("The completable returned is null");
                            e = new CompositeException(Arrays.asList(e, npe));
                            s.onError(e);
                            return;
                        }
                        c.unsafeSubscribe(new CompletableSubscriber(){

                            @Override
                            public void onCompleted() {
                                s.onCompleted();
                            }

                            @Override
                            public void onError(Throwable e) {
                                s.onError(e);
                            }

                            @Override
                            public void onSubscribe(Subscription d) {
                                sd.set(d);
                            }
                        });
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        sd.set(d);
                    }
                });
            }
        });
    }

    public final Completable repeat() {
        return Completable.fromObservable(this.toObservable().repeat());
    }

    public final Completable repeat(long times) {
        return Completable.fromObservable(this.toObservable().repeat(times));
    }

    public final Completable repeatWhen(Func1<? super Observable<? extends Void>, ? extends Observable<?>> handler) {
        Completable.requireNonNull(handler);
        return Completable.fromObservable(this.toObservable().repeatWhen(handler));
    }

    public final Completable retry() {
        return Completable.fromObservable(this.toObservable().retry());
    }

    public final Completable retry(Func2<Integer, Throwable, Boolean> predicate) {
        return Completable.fromObservable(this.toObservable().retry(predicate));
    }

    public final Completable retry(long times) {
        return Completable.fromObservable(this.toObservable().retry(times));
    }

    public final Completable retryWhen(Func1<? super Observable<? extends Throwable>, ? extends Observable<?>> handler) {
        return Completable.fromObservable(this.toObservable().retryWhen(handler));
    }

    public final Completable startWith(Completable other) {
        Completable.requireNonNull(other);
        return Completable.concat(other, this);
    }

    public final <T> Observable<T> startWith(Observable<T> other) {
        Completable.requireNonNull(other);
        return this.toObservable().startWith(other);
    }

    public final Subscription subscribe() {
        final MultipleAssignmentSubscription mad = new MultipleAssignmentSubscription();
        this.unsafeSubscribe(new CompletableSubscriber(){

            @Override
            public void onCompleted() {
                mad.unsubscribe();
            }

            @Override
            public void onError(Throwable e) {
                ERROR_HANDLER.handleError(e);
                mad.unsubscribe();
                Completable.deliverUncaughtException(e);
            }

            @Override
            public void onSubscribe(Subscription d) {
                mad.set(d);
            }
        });
        return mad;
    }

    public final Subscription subscribe(final Action0 onComplete) {
        Completable.requireNonNull(onComplete);
        final MultipleAssignmentSubscription mad = new MultipleAssignmentSubscription();
        this.unsafeSubscribe(new CompletableSubscriber(){
            boolean done;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                if (!this.done) {
                    this.done = true;
                    try {
                        onComplete.call();
                    }
                    catch (Throwable e) {
                        ERROR_HANDLER.handleError(e);
                        Completable.deliverUncaughtException(e);
                    }
                    finally {
                        mad.unsubscribe();
                    }
                }
            }

            @Override
            public void onError(Throwable e) {
                ERROR_HANDLER.handleError(e);
                mad.unsubscribe();
                Completable.deliverUncaughtException(e);
            }

            @Override
            public void onSubscribe(Subscription d) {
                mad.set(d);
            }
        });
        return mad;
    }

    public final Subscription subscribe(final Action1<? super Throwable> onError, final Action0 onComplete) {
        Completable.requireNonNull(onError);
        Completable.requireNonNull(onComplete);
        final MultipleAssignmentSubscription mad = new MultipleAssignmentSubscription();
        this.unsafeSubscribe(new CompletableSubscriber(){
            boolean done;

            @Override
            public void onCompleted() {
                if (!this.done) {
                    this.done = true;
                    try {
                        onComplete.call();
                    }
                    catch (Throwable e) {
                        this.callOnError(e);
                        return;
                    }
                    mad.unsubscribe();
                }
            }

            @Override
            public void onError(Throwable e) {
                if (!this.done) {
                    this.done = true;
                    this.callOnError(e);
                } else {
                    ERROR_HANDLER.handleError(e);
                    Completable.deliverUncaughtException(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void callOnError(Throwable e) {
                try {
                    onError.call(e);
                }
                catch (Throwable ex) {
                    e = new CompositeException(Arrays.asList(e, ex));
                    ERROR_HANDLER.handleError(e);
                    Completable.deliverUncaughtException(e);
                }
                finally {
                    mad.unsubscribe();
                }
            }

            @Override
            public void onSubscribe(Subscription d) {
                mad.set(d);
            }
        });
        return mad;
    }

    private static void deliverUncaughtException(Throwable e) {
        Thread thread = Thread.currentThread();
        thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
    }

    public final void unsafeSubscribe(CompletableSubscriber s) {
        Completable.requireNonNull(s);
        try {
            CompletableOnSubscribe onSubscribeDecorated = HOOK.onSubscribeStart(this, this.onSubscribe);
            onSubscribeDecorated.call(s);
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            ex = HOOK.onSubscribeError(ex);
            ERROR_HANDLER.handleError(ex);
            throw Completable.toNpe(ex);
        }
    }

    public final void subscribe(CompletableSubscriber s) {
        if (!(s instanceof SafeCompletableSubscriber)) {
            s = new SafeCompletableSubscriber(s);
        }
        this.unsafeSubscribe(s);
    }

    public final <T> void unsafeSubscribe(Subscriber<T> s) {
        this.unsafeSubscribe(s, true);
    }

    private final <T> void unsafeSubscribe(final Subscriber<T> s, boolean callOnStart) {
        Completable.requireNonNull(s);
        try {
            if (callOnStart) {
                s.onStart();
            }
            this.unsafeSubscribe(new CompletableSubscriber(){

                @Override
                public void onCompleted() {
                    s.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    s.onError(e);
                }

                @Override
                public void onSubscribe(Subscription d) {
                    s.add(d);
                }
            });
            RxJavaPlugins.getInstance().getObservableExecutionHook().onSubscribeReturn(s);
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            ex = HOOK.onSubscribeError(ex);
            ERROR_HANDLER.handleError(ex);
            throw Completable.toNpe(ex);
        }
    }

    public final <T> void subscribe(Subscriber<T> s) {
        s.onStart();
        if (!(s instanceof SafeSubscriber)) {
            s = new SafeSubscriber<T>(s);
        }
        this.unsafeSubscribe(s, false);
    }

    public final Completable subscribeOn(final Scheduler scheduler) {
        Completable.requireNonNull(scheduler);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s) {
                final Scheduler.Worker w = scheduler.createWorker();
                w.schedule(new Action0(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void call() {
                        try {
                            Completable.this.unsafeSubscribe(s);
                        }
                        finally {
                            w.unsubscribe();
                        }
                    }
                });
            }
        });
    }

    public final Completable timeout(long timeout, TimeUnit unit) {
        return this.timeout0(timeout, unit, Schedulers.computation(), null);
    }

    public final Completable timeout(long timeout, TimeUnit unit, Completable other) {
        Completable.requireNonNull(other);
        return this.timeout0(timeout, unit, Schedulers.computation(), other);
    }

    public final Completable timeout(long timeout, TimeUnit unit, Scheduler scheduler) {
        return this.timeout0(timeout, unit, scheduler, null);
    }

    public final Completable timeout(long timeout, TimeUnit unit, Scheduler scheduler, Completable other) {
        Completable.requireNonNull(other);
        return this.timeout0(timeout, unit, scheduler, other);
    }

    public final Completable timeout0(long timeout, TimeUnit unit, Scheduler scheduler, Completable other) {
        Completable.requireNonNull(unit);
        Completable.requireNonNull(scheduler);
        return Completable.create(new CompletableOnSubscribeTimeout(this, timeout, unit, scheduler, other));
    }

    public final <U> U to(Func1<? super Completable, U> converter) {
        return converter.call(this);
    }

    public final <T> Observable<T> toObservable() {
        return Observable.create(new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> s) {
                Completable.this.unsafeSubscribe(s);
            }
        });
    }

    public final <T> Single<T> toSingle(final Func0<? extends T> completionValueFunc0) {
        Completable.requireNonNull(completionValueFunc0);
        return Single.create(new Single.OnSubscribe<T>(){

            @Override
            public void call(final SingleSubscriber<? super T> s) {
                Completable.this.unsafeSubscribe(new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        Object v;
                        try {
                            v = completionValueFunc0.call();
                        }
                        catch (Throwable e) {
                            s.onError(e);
                            return;
                        }
                        if (v == null) {
                            s.onError(new NullPointerException("The value supplied is null"));
                        } else {
                            s.onSuccess(v);
                        }
                    }

                    @Override
                    public void onError(Throwable e) {
                        s.onError(e);
                    }

                    @Override
                    public void onSubscribe(Subscription d) {
                        s.add(d);
                    }
                });
            }
        });
    }

    public final <T> Single<T> toSingleDefault(final T completionValue) {
        Completable.requireNonNull(completionValue);
        return this.toSingle(new Func0<T>(){

            @Override
            public T call() {
                return completionValue;
            }
        });
    }

    public final Completable unsubscribeOn(final Scheduler scheduler) {
        Completable.requireNonNull(scheduler);
        return Completable.create(new CompletableOnSubscribe(){

            @Override
            public void call(final CompletableSubscriber s) {
                Completable.this.unsafeSubscribe(new CompletableSubscriber(){

                    @Override
                    public void onCompleted() {
                        s.onCompleted();
                    }

                    @Override
                    public void onError(Throwable e) {
                        s.onError(e);
                    }

                    @Override
                    public void onSubscribe(final Subscription d) {
                        s.onSubscribe(Subscriptions.create(new Action0(){

                            @Override
                            public void call() {
                                final Scheduler.Worker w = scheduler.createWorker();
                                w.schedule(new Action0(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void call() {
                                        try {
                                            d.unsubscribe();
                                        }
                                        finally {
                                            w.unsubscribe();
                                        }
                                    }
                                });
                            }
                        }));
                    }
                });
            }
        });
    }

    public static interface CompletableTransformer
    extends Func1<Completable, Completable> {
    }

    public static interface CompletableSubscriber {
        public void onCompleted();

        public void onError(Throwable var1);

        public void onSubscribe(Subscription var1);
    }

    public static interface CompletableOperator
    extends Func1<CompletableSubscriber, CompletableSubscriber> {
    }

    public static interface CompletableOnSubscribe
    extends Action1<CompletableSubscriber> {
    }
}

