/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.rx;

import com.lambdaworks.rx.annotations.Experimental;
import com.lambdaworks.rx.exceptions.MissingBackpressureException;

@Experimental
public final class BackpressureOverflow {
    public static final Strategy ON_OVERFLOW_DEFAULT = Error.INSTANCE;
    public static final Strategy ON_OVERFLOW_ERROR = Error.INSTANCE;
    public static final Strategy ON_OVERFLOW_DROP_OLDEST = DropOldest.INSTANCE;
    public static final Strategy ON_OVERFLOW_DROP_LATEST = DropLatest.INSTANCE;

    static class Error
    implements Strategy {
        static final Error INSTANCE = new Error();

        private Error() {
        }

        @Override
        public boolean mayAttemptDrop() throws MissingBackpressureException {
            throw new MissingBackpressureException("Overflowed buffer");
        }
    }

    static class DropLatest
    implements Strategy {
        static final DropLatest INSTANCE = new DropLatest();

        private DropLatest() {
        }

        @Override
        public boolean mayAttemptDrop() {
            return false;
        }
    }

    static class DropOldest
    implements Strategy {
        static final DropOldest INSTANCE = new DropOldest();

        private DropOldest() {
        }

        @Override
        public boolean mayAttemptDrop() {
            return true;
        }
    }

    public static interface Strategy {
        public boolean mayAttemptDrop() throws MissingBackpressureException;
    }
}

