/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.resource;

import com.lambdaworks.io.netty.util.concurrent.EventExecutor;
import com.lambdaworks.io.netty.util.concurrent.EventExecutorGroup;
import com.lambdaworks.rx.Scheduler;
import com.lambdaworks.rx.Subscription;
import com.lambdaworks.rx.functions.Action0;
import com.lambdaworks.rx.internal.schedulers.ScheduledAction;
import com.lambdaworks.rx.internal.util.SubscriptionList;
import com.lambdaworks.rx.subscriptions.CompositeSubscription;
import com.lambdaworks.rx.subscriptions.Subscriptions;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class RxJavaEventExecutorGroupScheduler
extends Scheduler {
    private final EventExecutorGroup eventLoopGroup;

    public RxJavaEventExecutorGroupScheduler(EventExecutorGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    @Override
    public Scheduler.Worker createWorker() {
        EventExecutor eventLoop = this.eventLoopGroup.next();
        return new ScheduledExecutorServiceWorker(eventLoop);
    }

    private static class ScheduledExecutorServiceWorker
    extends Scheduler.Worker {
        private final SubscriptionList serial;
        private final CompositeSubscription timed;
        private final SubscriptionList both;
        private final ScheduledExecutorService scheduledExecutor;

        public ScheduledExecutorServiceWorker(EventExecutor scheduledExecutor) {
            this.scheduledExecutor = scheduledExecutor;
            this.serial = new SubscriptionList();
            this.timed = new CompositeSubscription();
            this.both = new SubscriptionList(this.serial, this.timed);
        }

        @Override
        public Subscription schedule(Action0 action) {
            return this.schedule(action, 0L, TimeUnit.DAYS);
        }

        @Override
        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            ScheduledAction sa;
            if (this.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            if (delayTime <= 0L) {
                sa = new ScheduledAction(action, this.serial);
                this.serial.add(sa);
            } else {
                sa = new ScheduledAction(action, this.timed);
                this.timed.add(sa);
            }
            final ScheduledFuture<?> result = this.scheduledExecutor.schedule(sa, delayTime, unit);
            Subscription cancelFuture = Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    result.cancel(false);
                }
            });
            sa.add(cancelFuture);
            return sa;
        }

        @Override
        public void unsubscribe() {
            this.both.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.both.isUnsubscribed();
        }
    }
}

