/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.resource;

import com.lambdaworks.io.netty.channel.EventLoopGroup;
import com.lambdaworks.io.netty.channel.nio.NioEventLoopGroup;
import com.lambdaworks.io.netty.util.concurrent.DefaultEventExecutorGroup;
import com.lambdaworks.io.netty.util.concurrent.DefaultPromise;
import com.lambdaworks.io.netty.util.concurrent.DefaultThreadFactory;
import com.lambdaworks.io.netty.util.concurrent.EventExecutorGroup;
import com.lambdaworks.io.netty.util.concurrent.Future;
import com.lambdaworks.io.netty.util.concurrent.GlobalEventExecutor;
import com.lambdaworks.io.netty.util.concurrent.Promise;
import com.lambdaworks.io.netty.util.internal.logging.InternalLogger;
import com.lambdaworks.io.netty.util.internal.logging.InternalLoggerFactory;
import com.lambdaworks.redis.EpollProvider;
import com.lambdaworks.redis.resource.EventLoopGroupProvider;
import com.lambdaworks.redis.resource.Futures;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class DefaultEventLoopGroupProvider
implements EventLoopGroupProvider {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultEventLoopGroupProvider.class);
    private final Map<Class<? extends EventExecutorGroup>, EventExecutorGroup> eventLoopGroups = new ConcurrentHashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup>();
    private final Map<ExecutorService, Long> refCounter = new ConcurrentHashMap<ExecutorService, Long>();
    private final int numberOfThreads;
    private volatile boolean shutdownCalled = false;

    public DefaultEventLoopGroupProvider(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends EventLoopGroup> T allocate(Class<T> type) {
        DefaultEventLoopGroupProvider defaultEventLoopGroupProvider = this;
        synchronized (defaultEventLoopGroupProvider) {
            return (T)((EventLoopGroup)this.addReference(this.getOrCreate(type)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ExecutorService> T addReference(T reference) {
        Map<ExecutorService, Long> map = this.refCounter;
        synchronized (map) {
            long counter = 0L;
            if (this.refCounter.containsKey(reference)) {
                counter = this.refCounter.get(reference);
            }
            logger.debug("Adding reference to {}, existing ref count {}", (Object)reference, (Object)counter);
            this.refCounter.put(reference, ++counter);
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ExecutorService> T release(T reference) {
        Map<ExecutorService, Long> map = this.refCounter;
        synchronized (map) {
            long counter = 0L;
            if (this.refCounter.containsKey(reference)) {
                counter = this.refCounter.get(reference);
            }
            if (counter < 1L) {
                logger.debug("Attempting to release {} but ref count is {}", (Object)reference, (Object)counter);
            }
            if (--counter == 0L) {
                this.refCounter.remove(reference);
            } else {
                this.refCounter.put(reference, counter);
            }
        }
        return reference;
    }

    private <T extends EventLoopGroup> T getOrCreate(Class<T> type) {
        if (this.shutdownCalled) {
            throw new IllegalStateException("Provider is shut down and can not longer provide resources");
        }
        if (!this.eventLoopGroups.containsKey(type)) {
            this.eventLoopGroups.put(type, DefaultEventLoopGroupProvider.createEventLoopGroup(type, this.numberOfThreads));
        }
        return (T)((EventLoopGroup)this.eventLoopGroups.get(type));
    }

    public static <T extends EventExecutorGroup> EventExecutorGroup createEventLoopGroup(Class<T> type, int numberOfThreads) {
        if (DefaultEventExecutorGroup.class.equals(type)) {
            return new DefaultEventExecutorGroup(numberOfThreads, new DefaultThreadFactory("lettuce-eventExecutorLoop", true));
        }
        if (NioEventLoopGroup.class.equals(type)) {
            return new NioEventLoopGroup(numberOfThreads, new DefaultThreadFactory("lettuce-nioEventLoop", true));
        }
        if (EpollProvider.epollEventLoopGroupClass != null && EpollProvider.epollEventLoopGroupClass.equals(type)) {
            return EpollProvider.newEventLoopGroup(numberOfThreads, new DefaultThreadFactory("lettuce-epollEventLoop", true));
        }
        throw new IllegalArgumentException("Type " + type.getName() + " not supported");
    }

    public Promise<Boolean> release(EventExecutorGroup eventLoopGroup, long quietPeriod, long timeout, TimeUnit unit) {
        Class<?> key = this.getKey(this.release(eventLoopGroup));
        if (key == null && eventLoopGroup.isShuttingDown() || this.refCounter.containsKey(eventLoopGroup)) {
            DefaultPromise<Boolean> promise = new DefaultPromise<Boolean>(GlobalEventExecutor.INSTANCE);
            promise.setSuccess(true);
            return promise;
        }
        if (key != null) {
            this.eventLoopGroups.remove(key);
        }
        Future<?> shutdownFuture = eventLoopGroup.shutdownGracefully(quietPeriod, timeout, unit);
        return Futures.toBooleanPromise(shutdownFuture);
    }

    private Class<?> getKey(EventExecutorGroup eventLoopGroup) {
        Class key = null;
        HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup> copy = new HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup>(this.eventLoopGroups);
        for (Map.Entry entry : copy.entrySet()) {
            if (entry.getValue() != eventLoopGroup) continue;
            key = (Class)entry.getKey();
            break;
        }
        return key;
    }

    @Override
    public int threadPoolSize() {
        return this.numberOfThreads;
    }

    @Override
    public Future<Boolean> shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        this.shutdownCalled = true;
        HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup> copy = new HashMap<Class<? extends EventExecutorGroup>, EventExecutorGroup>(this.eventLoopGroups);
        DefaultPromise overall = new DefaultPromise(GlobalEventExecutor.INSTANCE);
        DefaultPromise<Object> lastRelease = new DefaultPromise<Object>(GlobalEventExecutor.INSTANCE);
        Futures.PromiseAggregator aggregator = new Futures.PromiseAggregator(overall);
        aggregator.expectMore(1 + copy.size());
        aggregator.arm();
        for (EventExecutorGroup executorGroup : copy.values()) {
            Promise<Boolean> shutdown = Futures.toBooleanPromise(this.release(executorGroup, quietPeriod, timeout, timeUnit));
            aggregator.add(shutdown);
        }
        aggregator.add(lastRelease);
        lastRelease.setSuccess(null);
        return Futures.toBooleanPromise(overall);
    }
}

