/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.io.netty.bootstrap.Bootstrap;
import com.lambdaworks.io.netty.channel.Channel;
import com.lambdaworks.io.netty.channel.ChannelHandler;
import com.lambdaworks.io.netty.channel.ChannelHandlerContext;
import com.lambdaworks.io.netty.channel.ChannelInboundHandlerAdapter;
import com.lambdaworks.io.netty.util.Timeout;
import com.lambdaworks.io.netty.util.Timer;
import com.lambdaworks.io.netty.util.TimerTask;
import com.lambdaworks.io.netty.util.concurrent.EventExecutorGroup;
import com.lambdaworks.io.netty.util.internal.logging.InternalLogLevel;
import com.lambdaworks.io.netty.util.internal.logging.InternalLogger;
import com.lambdaworks.io.netty.util.internal.logging.InternalLoggerFactory;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.ChannelLogDescriptor;
import com.lambdaworks.redis.protocol.ReconnectionHandler;
import com.lambdaworks.redis.protocol.ReconnectionListener;
import com.lambdaworks.redis.resource.Delay;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@ChannelHandler.Sharable
public class ConnectionWatchdog
extends ChannelInboundHandlerAdapter
implements TimerTask {
    public static final long LOGGING_QUIET_TIME_MS = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ConnectionWatchdog.class);
    private final Delay reconnectDelay;
    private final Bootstrap bootstrap;
    private final EventExecutorGroup reconnectWorkers;
    private final ReconnectionHandler reconnectionHandler;
    private final ReconnectionListener reconnectionListener;
    private boolean listenOnChannelInactive;
    private Channel channel;
    private final Timer timer;
    private SocketAddress remoteAddress;
    private int attempts;
    private long lastReconnectionLogging = -1L;
    private volatile String logPrefix;

    public ConnectionWatchdog(Delay reconnectDelay, ClientOptions clientOptions, Bootstrap bootstrap, Timer timer, EventExecutorGroup reconnectWorkers, final Supplier<SocketAddress> socketAddressSupplier, ReconnectionListener reconnectionListener) {
        LettuceAssert.notNull(reconnectDelay, "Delay must not be null");
        LettuceAssert.notNull(clientOptions, "ClientOptions must not be null");
        LettuceAssert.notNull(bootstrap, "Bootstrap must not be null");
        LettuceAssert.notNull(timer, "Timer must not be null");
        LettuceAssert.notNull(reconnectWorkers, "reconnectWorkers must not be null");
        LettuceAssert.notNull(reconnectionListener, "ReconnectionListener must not be null");
        this.reconnectDelay = reconnectDelay;
        this.bootstrap = bootstrap;
        this.timer = timer;
        this.reconnectWorkers = reconnectWorkers;
        this.reconnectionListener = reconnectionListener;
        Supplier<SocketAddress> wrappedSocketAddressSupplier = new Supplier<SocketAddress>(){

            @Override
            public SocketAddress get() {
                if (socketAddressSupplier != null) {
                    try {
                        ConnectionWatchdog.this.remoteAddress = (SocketAddress)socketAddressSupplier.get();
                    }
                    catch (RuntimeException e) {
                        logger.warn("Cannot retrieve the current address from socketAddressSupplier: " + e.toString() + ", reusing old address " + ConnectionWatchdog.this.remoteAddress);
                    }
                }
                return ConnectionWatchdog.this.remoteAddress;
            }
        };
        this.reconnectionHandler = new ReconnectionHandler(clientOptions, bootstrap, wrappedSocketAddressSupplier);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        logger.debug("{} userEventTriggered({}, {})", this.logPrefix(), ctx, evt);
        if (evt instanceof ConnectionEvents.PrepareClose) {
            ConnectionEvents.PrepareClose prepareClose = (ConnectionEvents.PrepareClose)evt;
            this.prepareClose(prepareClose);
        }
        if (evt instanceof ConnectionEvents.Activated) {
            this.attempts = 0;
        }
        super.userEventTriggered(ctx, evt);
    }

    void prepareClose(ConnectionEvents.PrepareClose prepareClose) {
        this.setListenOnChannelInactive(false);
        this.setReconnectSuspended(true);
        prepareClose.getPrepareCloseFuture().complete(true);
        this.reconnectionHandler.prepareClose();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.logPrefix = null;
        this.channel = ctx.channel();
        logger.debug("{} channelActive({})", (Object)this.logPrefix(), (Object)ctx);
        this.remoteAddress = this.channel.remoteAddress();
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.debug("{} channelInactive({})", (Object)this.logPrefix(), (Object)ctx);
        this.channel = null;
        if (this.listenOnChannelInactive && !this.reconnectionHandler.isReconnectSuspended()) {
            RedisChannelHandler channelHandler = ctx.pipeline().get(RedisChannelHandler.class);
            if (channelHandler != null) {
                this.reconnectionHandler.setTimeout(channelHandler.getTimeout());
                this.reconnectionHandler.setTimeoutUnit(channelHandler.getTimeoutUnit());
            }
            this.scheduleReconnect();
        } else {
            logger.debug("{} Reconnect scheduling disabled", (Object)this.logPrefix(), (Object)ctx);
            logger.debug("");
        }
        super.channelInactive(ctx);
    }

    public void scheduleReconnect() {
        logger.debug("{} scheduleReconnect()", (Object)this.logPrefix());
        if (!this.isEventLoopGroupActive()) {
            logger.debug("isEventLoopGroupActive() == false");
            return;
        }
        if (this.channel == null || !this.channel.isActive()) {
            ++this.attempts;
            int timeout = (int)this.reconnectDelay.getTimeUnit().toMillis(this.reconnectDelay.createDelay(this.attempts));
            logger.debug("{} Reconnect attempt {}, delay {}ms", this.logPrefix(), this.attempts, timeout);
            this.timer.newTimeout(new TimerTask(){

                @Override
                public void run(Timeout timeout) throws Exception {
                    if (!ConnectionWatchdog.this.isEventLoopGroupActive()) {
                        logger.debug("isEventLoopGroupActive() == false");
                        return;
                    }
                    ConnectionWatchdog.this.reconnectWorkers.submit(() -> {
                        ConnectionWatchdog.this.run(timeout);
                        return null;
                    });
                }
            }, timeout, TimeUnit.MILLISECONDS);
        } else {
            logger.debug("{} Skipping scheduleReconnect() because I have an active channel", (Object)this.logPrefix());
        }
    }

    @Override
    public void run(Timeout timeout) throws Exception {
        block6: {
            if (!this.isEventLoopGroupActive()) {
                logger.debug("isEventLoopGroupActive() == false");
                return;
            }
            boolean shouldLog = this.shouldLog();
            InternalLogLevel infoLevel = InternalLogLevel.INFO;
            InternalLogLevel warnLevel = InternalLogLevel.WARN;
            if (shouldLog) {
                this.lastReconnectionLogging = System.currentTimeMillis();
            } else {
                warnLevel = InternalLogLevel.DEBUG;
                infoLevel = InternalLogLevel.DEBUG;
            }
            try {
                this.reconnectionListener.onReconnect(new ConnectionEvents.Reconnect(this.attempts));
                this.reconnect(infoLevel, warnLevel);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
            catch (Exception e) {
                logger.log(warnLevel, "Cannot connect: {}", (Object)e.toString());
                if (this.isReconnectSuspended()) break block6;
                this.scheduleReconnect();
            }
        }
    }

    protected void reconnect(InternalLogLevel infoLevel, InternalLogLevel warnLevel) throws Exception {
        logger.log(infoLevel, "Reconnecting, last destination was {}", (Object)this.remoteAddress);
        this.reconnectionHandler.reconnect(infoLevel);
    }

    private boolean isEventLoopGroupActive() {
        return this.isEventLoopGroupActive(this.bootstrap.group()) && this.isEventLoopGroupActive(this.reconnectWorkers);
    }

    private boolean isEventLoopGroupActive(EventExecutorGroup executorService) {
        return !executorService.isShutdown() && !executorService.isTerminated() && !executorService.isShuttingDown();
    }

    private boolean shouldLog() {
        long quietUntil = this.lastReconnectionLogging + LOGGING_QUIET_TIME_MS;
        return quietUntil <= System.currentTimeMillis();
    }

    public void setListenOnChannelInactive(boolean listenOnChannelInactive) {
        this.listenOnChannelInactive = listenOnChannelInactive;
    }

    public boolean isListenOnChannelInactive() {
        return this.listenOnChannelInactive;
    }

    public boolean isReconnectSuspended() {
        return this.reconnectionHandler.isReconnectSuspended();
    }

    public void setReconnectSuspended(boolean reconnectSuspended) {
        this.reconnectionHandler.setReconnectSuspended(true);
    }

    private String logPrefix() {
        if (this.logPrefix != null) {
            return this.logPrefix;
        }
        StringBuffer buffer = new StringBuffer(64);
        buffer.append('[').append(ChannelLogDescriptor.logDescriptor(this.channel)).append(']');
        this.logPrefix = buffer.toString();
        return this.logPrefix;
    }
}

