/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.io.netty.buffer.ByteBuf;
import com.lambdaworks.io.netty.channel.Channel;
import com.lambdaworks.io.netty.channel.ChannelDuplexHandler;
import com.lambdaworks.io.netty.channel.ChannelFuture;
import com.lambdaworks.io.netty.channel.ChannelFutureListener;
import com.lambdaworks.io.netty.channel.ChannelHandler;
import com.lambdaworks.io.netty.channel.ChannelHandlerContext;
import com.lambdaworks.io.netty.channel.ChannelPromise;
import com.lambdaworks.io.netty.channel.local.LocalAddress;
import com.lambdaworks.io.netty.util.concurrent.Future;
import com.lambdaworks.io.netty.util.concurrent.GenericFutureListener;
import com.lambdaworks.io.netty.util.internal.logging.InternalLogLevel;
import com.lambdaworks.io.netty.util.internal.logging.InternalLogger;
import com.lambdaworks.io.netty.util.internal.logging.InternalLoggerFactory;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.internal.LettuceFactories;
import com.lambdaworks.redis.internal.LettuceLists;
import com.lambdaworks.redis.internal.LettuceSets;
import com.lambdaworks.redis.protocol.ChannelLogDescriptor;
import com.lambdaworks.redis.protocol.CommandWrapper;
import com.lambdaworks.redis.protocol.ConnectionWatchdog;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.protocol.RedisStateMachine;
import com.lambdaworks.redis.protocol.WithLatency;
import com.lambdaworks.redis.resource.ClientResources;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

@ChannelHandler.Sharable
public class CommandHandler<K, V>
extends ChannelDuplexHandler
implements RedisChannelWriter<K, V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CommandHandler.class);
    private static final WriteLogListener WRITE_LOG_LISTENER = new WriteLogListener();
    private static final Set<String> SUPPRESS_IO_EXCEPTION_MESSAGES = LettuceSets.unmodifiableSet("Connection reset by peer", "Broken pipe", "Connection timed out");
    protected final ClientOptions clientOptions;
    protected final ClientResources clientResources;
    protected final Queue<RedisCommand<K, V, ?>> queue;
    protected final AtomicLong writers = new AtomicLong();
    protected final Object stateLock = new Object();
    protected final Deque<RedisCommand<K, V, ?>> commandBuffer = LettuceFactories.newConcurrentQueue();
    protected final Deque<RedisCommand<K, V, ?>> transportBuffer = LettuceFactories.newConcurrentQueue();
    protected ByteBuf buffer;
    protected RedisStateMachine<K, V> rsm;
    protected Channel channel;
    private volatile ConnectionWatchdog connectionWatchdog;
    private final boolean traceEnabled;
    private final boolean debugEnabled;
    private final Reliability reliability;
    private volatile LifecycleState lifecycleState = LifecycleState.NOT_CONNECTED;
    private Thread exclusiveLockOwner;
    private RedisChannelHandler<K, V> redisChannelHandler;
    private Throwable connectionError;
    private String logPrefix;
    private boolean autoFlushCommands = true;

    public CommandHandler(ClientOptions clientOptions, ClientResources clientResources, Queue<RedisCommand<K, V, ?>> queue) {
        LettuceAssert.notNull(clientOptions, "clientOptions must not be null");
        LettuceAssert.notNull(clientResources, "clientResources must not be null");
        LettuceAssert.notNull(queue, "queue must not be null");
        this.clientOptions = clientOptions;
        this.clientResources = clientResources;
        this.queue = queue;
        this.traceEnabled = logger.isTraceEnabled();
        this.debugEnabled = logger.isDebugEnabled();
        this.reliability = clientOptions.isAutoReconnect() ? Reliability.AT_LEAST_ONCE : Reliability.AT_MOST_ONCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.setState(LifecycleState.REGISTERED);
        this.buffer = ctx.alloc().directBuffer(65536);
        this.rsm = new RedisStateMachine();
        Object object = this.stateLock;
        synchronized (object) {
            this.channel = ctx.channel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.releaseBuffer();
        this.releaseStateMachine();
        if (this.lifecycleState == LifecycleState.CLOSED) {
            this.cancelCommands("Connection closed");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.channel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf input = (ByteBuf)msg;
        if (!input.isReadable() || input.refCnt() == 0 || this.buffer == null) {
            return;
        }
        try {
            this.buffer.writeBytes(input);
            if (this.debugEnabled) {
                if (this.traceEnabled) {
                    logger.trace("{} Received: {}", (Object)this.logPrefix(), (Object)this.buffer.toString(Charset.defaultCharset()).trim());
                }
                if (this.debugEnabled) {
                    logger.debug("{} Queue contains: {} commands", (Object)this.logPrefix(), (Object)this.queue.size());
                }
            }
            this.decode(ctx, this.buffer);
        }
        finally {
            input.release();
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer) throws InterruptedException {
        while (!this.queue.isEmpty()) {
            RedisCommand<K, V, ?> unwrappedCommand;
            RedisCommand<K, V, ?> command = this.queue.peek();
            if (this.debugEnabled) {
                logger.debug("{} Queue contains: {} commands", (Object)this.logPrefix(), (Object)this.queue.size());
            }
            WithLatency withLatency = null;
            if (this.clientResources.commandLatencyCollector().isEnabled() && (unwrappedCommand = CommandWrapper.unwrap(command)) instanceof WithLatency && (withLatency = (WithLatency)((Object)unwrappedCommand)).getFirstResponse() == -1L) {
                withLatency.firstResponse(this.nanoTime());
            }
            if (!this.rsm.decode(buffer, command, command.getOutput())) {
                return;
            }
            command = this.queue.poll();
            this.recordLatency(withLatency, command.getType());
            command.complete();
            if (buffer == null || buffer.refCnt() == 0) continue;
            buffer.discardReadBytes();
        }
    }

    private void recordLatency(WithLatency withLatency, ProtocolKeyword commandType) {
        if (withLatency != null && this.clientResources.commandLatencyCollector().isEnabled() && this.channel != null && this.remote() != null) {
            long firstResponseLatency = this.nanoTime() - withLatency.getFirstResponse();
            long completionLatency = this.nanoTime() - withLatency.getSent();
            this.clientResources.commandLatencyCollector().recordCommandLatency(this.local(), this.remote(), commandType, firstResponseLatency, completionLatency);
        }
    }

    private SocketAddress remote() {
        return this.channel.remoteAddress();
    }

    private SocketAddress local() {
        if (this.channel.localAddress() != null) {
            return this.channel.localAddress();
        }
        return LocalAddress.ANY;
    }

    @Override
    public <T, C extends RedisCommand<K, V, T>> C write(C command) {
        LettuceAssert.notNull(command, "command must not be null");
        try {
            this.incrementWriters();
            if (this.lifecycleState == LifecycleState.CLOSED) {
                throw new RedisException("Connection is closed");
            }
            if (this.clientOptions.getRequestQueueSize() != Integer.MAX_VALUE && this.commandBuffer.size() + this.queue.size() >= this.clientOptions.getRequestQueueSize()) {
                throw new RedisException("Request queue size exceeded: " + this.clientOptions.getRequestQueueSize() + ". Commands are not accepted until the queue size drops.");
            }
            if ((this.channel == null || !this.isConnected()) && this.isRejectCommand()) {
                throw new RedisException("Currently not connected. Commands are rejected.");
            }
            Channel channel = this.channel;
            if (this.autoFlushCommands) {
                if (channel != null && this.isConnected() && channel.isActive()) {
                    this.writeToChannel(command, channel);
                } else {
                    this.writeToBuffer(command);
                }
            } else {
                this.bufferCommand(command);
            }
        }
        finally {
            this.decrementWriters();
            if (this.debugEnabled) {
                logger.debug("{} write() done", (Object)this.logPrefix());
            }
        }
        return command;
    }

    protected <C extends RedisCommand<K, V, T>, T> void writeToBuffer(C command) {
        if (this.commandBuffer.contains(command) || this.queue.contains(command)) {
            return;
        }
        if (this.connectionError != null) {
            if (this.debugEnabled) {
                logger.debug("{} writeToBuffer() Completing command {} due to connection error", (Object)this.logPrefix(), (Object)command);
            }
            command.completeExceptionally(this.connectionError);
            return;
        }
        this.bufferCommand(command);
    }

    protected <C extends RedisCommand<K, V, T>, T> void writeToChannel(C command, Channel channel) {
        if (this.reliability == Reliability.AT_MOST_ONCE) {
            this.writeAndFlush(command).addListener(new AtMostOnceWriteListener(command, this.queue));
        }
        if (this.reliability == Reliability.AT_LEAST_ONCE) {
            this.writeAndFlush(command).addListener(WRITE_LOG_LISTENER);
        }
    }

    protected void bufferCommand(RedisCommand<K, V, ?> command) {
        if (this.debugEnabled) {
            logger.debug("{} write() buffering command {}", (Object)this.logPrefix(), (Object)command);
        }
        this.commandBuffer.add(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementWriters() {
        if (this.exclusiveLockOwner == Thread.currentThread()) {
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            while (this.writers.get() < 0L) {
            }
            this.writers.incrementAndGet();
            return;
        }
    }

    protected void decrementWriters() {
        if (this.exclusiveLockOwner == Thread.currentThread()) {
            return;
        }
        this.writers.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockWritersExclusive() {
        if (this.exclusiveLockOwner == Thread.currentThread()) {
            this.writers.decrementAndGet();
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            while (!this.writers.compareAndSet(0L, -1L)) {
            }
            this.exclusiveLockOwner = Thread.currentThread();
            return;
        }
    }

    protected void unlockWritersExclusive() {
        if (this.exclusiveLockOwner == Thread.currentThread() && this.writers.incrementAndGet() == 0L) {
            this.exclusiveLockOwner = null;
        }
    }

    private boolean isRejectCommand() {
        if (this.clientOptions == null) {
            return false;
        }
        switch (this.clientOptions.getDisconnectedBehavior()) {
            case REJECT_COMMANDS: {
                return true;
            }
            case ACCEPT_COMMANDS: {
                return false;
            }
        }
        return !this.clientOptions.isAutoReconnect();
    }

    boolean isConnected() {
        return this.lifecycleState.ordinal() >= LifecycleState.CONNECTED.ordinal() && this.lifecycleState.ordinal() < LifecycleState.DISCONNECTED.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushCommands() {
        if (this.debugEnabled) {
            logger.debug("{} flushCommands()", (Object)this.logPrefix());
        }
        if (this.channel != null && this.isConnected()) {
            ArrayList queuedCommands;
            Object object = this.stateLock;
            synchronized (object) {
                try {
                    RedisCommand<K, V, ?> cmd;
                    this.lockWritersExclusive();
                    if (this.commandBuffer.isEmpty()) {
                        return;
                    }
                    queuedCommands = new ArrayList(this.commandBuffer.size());
                    while ((cmd = this.commandBuffer.poll()) != null) {
                        queuedCommands.add(cmd);
                    }
                }
                finally {
                    this.unlockWritersExclusive();
                }
            }
            if (this.debugEnabled) {
                logger.debug("{} flushCommands() Flushing {} commands", (Object)this.logPrefix(), (Object)queuedCommands.size());
            }
            if (this.reliability == Reliability.AT_MOST_ONCE) {
                this.writeAndFlush((RedisCommand)((Object)queuedCommands)).addListener(new AtMostOnceWriteListener(queuedCommands, this.queue));
            }
            if (this.reliability == Reliability.AT_LEAST_ONCE) {
                this.writeAndFlush((RedisCommand)((Object)queuedCommands)).addListener(WRITE_LOG_LISTENER);
            }
        }
    }

    private <C extends RedisCommand<K, V, ?>> ChannelFuture writeAndFlush(List<C> commands) {
        if (this.debugEnabled) {
            logger.debug("{} write() writeAndFlush commands {}", (Object)this.logPrefix(), (Object)commands);
        }
        this.transportBuffer.addAll(commands);
        return this.channel.writeAndFlush(commands);
    }

    private <C extends RedisCommand<K, V, ?>> ChannelFuture writeAndFlush(C command) {
        if (this.debugEnabled) {
            logger.debug("{} write() writeAndFlush command {}", (Object)this.logPrefix(), (Object)command);
        }
        this.transportBuffer.add(command);
        return this.channel.writeAndFlush(command);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.debugEnabled) {
            logger.debug("{} write(ctx, {}, promise)", (Object)this.logPrefix(), msg);
        }
        if (msg instanceof RedisCommand) {
            this.writeSingleCommand(ctx, (RedisCommand)msg, promise);
            return;
        }
        if (msg instanceof Collection) {
            this.writeBatch(ctx, (Collection)msg, promise);
        }
    }

    private void writeSingleCommand(ChannelHandlerContext ctx, RedisCommand<K, V, ?> command, ChannelPromise promise) throws Exception {
        if (command.isCancelled()) {
            this.transportBuffer.remove(command);
            return;
        }
        this.queueCommand(command, promise);
        ctx.write(command, promise);
    }

    private void writeBatch(ChannelHandlerContext ctx, Collection<RedisCommand<K, V, ?>> msg, ChannelPromise promise) throws Exception {
        Collection<RedisCommand<K, V, ?>> commands;
        Collection<RedisCommand<K, V, ?>> toWrite = commands = msg;
        boolean cancelledCommands = false;
        for (RedisCommand<K, V, ?> command : commands) {
            if (!command.isCancelled()) continue;
            cancelledCommands = true;
            break;
        }
        if (cancelledCommands) {
            toWrite = new ArrayList(commands.size());
            for (RedisCommand<K, V, ?> command : commands) {
                if (command.isCancelled()) {
                    this.transportBuffer.remove(command);
                    continue;
                }
                toWrite.add(command);
                this.queueCommand(command, promise);
            }
        } else {
            for (RedisCommand<K, V, ?> command : toWrite) {
                this.queueCommand(command, promise);
            }
        }
        if (!toWrite.isEmpty()) {
            ctx.write(toWrite, promise);
        }
    }

    private void queueCommand(RedisCommand<K, V, ?> command, ChannelPromise promise) throws Exception {
        try {
            if (command.getOutput() == null) {
                command.complete();
            } else {
                this.queue.add(command);
            }
            this.transportBuffer.remove(command);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
            promise.setFailure(e);
            throw e;
        }
    }

    private long nanoTime() {
        return System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.logPrefix = null;
        this.connectionWatchdog = null;
        if (this.debugEnabled) {
            logger.debug("{} channelActive()", (Object)this.logPrefix());
        }
        if (ctx != null && ctx.pipeline() != null) {
            Map<String, ChannelHandler> map = ctx.pipeline().toMap();
            for (ChannelHandler handler : map.values()) {
                if (!(handler instanceof ConnectionWatchdog)) continue;
                this.connectionWatchdog = (ConnectionWatchdog)handler;
            }
        }
        Object object = this.stateLock;
        synchronized (object) {
            try {
                this.lockWritersExclusive();
                this.setStateIfNotClosed(LifecycleState.CONNECTED);
                try {
                    this.moveQueuedCommandsToCommandBuffer();
                    this.activateCommandHandlerAndExecuteBufferedCommands(ctx);
                }
                catch (Exception e) {
                    if (this.debugEnabled) {
                        logger.debug("{} channelActive() ran into an exception", (Object)this.logPrefix());
                    }
                    if (this.clientOptions.isCancelCommandsOnReconnectFailure()) {
                        this.reset();
                    }
                    throw e;
                }
            }
            finally {
                this.unlockWritersExclusive();
            }
        }
        super.channelActive(ctx);
        if (this.channel != null) {
            this.channel.eventLoop().submit(new Runnable(){

                @Override
                public void run() {
                    CommandHandler.this.channel.pipeline().fireUserEventTriggered(new ConnectionEvents.Activated());
                }
            });
        }
        if (this.debugEnabled) {
            logger.debug("{} channelActive() done", (Object)this.logPrefix());
        }
    }

    private void moveQueuedCommandsToCommandBuffer() {
        List<RedisCommand<K, V, ?>> queuedCommands = this.drainCommands(this.queue);
        Collections.reverse(queuedCommands);
        List<RedisCommand<K, V, ?>> transportBufferCommands = this.drainCommands(this.transportBuffer);
        Collections.reverse(transportBufferCommands);
        queuedCommands.addAll(transportBufferCommands);
        logger.debug("{} moveQueuedCommandsToCommandBuffer {} command(s) added to buffer", (Object)this.logPrefix(), (Object)queuedCommands.size());
        for (RedisCommand<K, V, ?> command : queuedCommands) {
            this.commandBuffer.addFirst(command);
        }
    }

    private List<RedisCommand<K, V, ?>> drainCommands(Collection<RedisCommand<K, V, ?>> source) {
        ArrayList target = new ArrayList(source.size());
        target.addAll(source);
        source.removeAll(target);
        return target;
    }

    protected void activateCommandHandlerAndExecuteBufferedCommands(ChannelHandlerContext ctx) {
        this.connectionError = null;
        if (this.debugEnabled) {
            logger.debug("{} activateCommandHandlerAndExecuteBufferedCommands {} command(s) buffered", (Object)this.logPrefix(), (Object)this.commandBuffer.size());
        }
        this.channel = ctx.channel();
        if (this.redisChannelHandler != null) {
            if (this.debugEnabled) {
                logger.debug("{} activating channel handler", (Object)this.logPrefix());
            }
            this.setStateIfNotClosed(LifecycleState.ACTIVATING);
            this.redisChannelHandler.activated();
        }
        this.setStateIfNotClosed(LifecycleState.ACTIVE);
        this.flushCommands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.debugEnabled) {
            logger.debug("{} channelInactive()", (Object)this.logPrefix());
        }
        Object object = this.stateLock;
        synchronized (object) {
            try {
                this.lockWritersExclusive();
                this.setStateIfNotClosed(LifecycleState.DISCONNECTED);
                if (this.redisChannelHandler != null) {
                    if (this.debugEnabled) {
                        logger.debug("{} deactivating channel handler", (Object)this.logPrefix());
                    }
                    this.setStateIfNotClosed(LifecycleState.DEACTIVATING);
                    this.redisChannelHandler.deactivated();
                }
                this.setStateIfNotClosed(LifecycleState.DEACTIVATED);
                this.commandBuffer.addAll(this.queue);
                this.queue.removeAll(this.commandBuffer);
            }
            finally {
                this.unlockWritersExclusive();
            }
        }
        if (this.buffer != null) {
            this.rsm.reset();
            this.buffer.clear();
        }
        if (this.debugEnabled) {
            logger.debug("{} channelInactive() done", (Object)this.logPrefix());
        }
        super.channelInactive(ctx);
    }

    protected void setStateIfNotClosed(LifecycleState lifecycleState) {
        if (this.lifecycleState != LifecycleState.CLOSED) {
            this.setState(lifecycleState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(LifecycleState lifecycleState) {
        Object object = this.stateLock;
        synchronized (object) {
            this.lifecycleState = lifecycleState;
        }
    }

    protected LifecycleState getState() {
        return this.lifecycleState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelCommands(String message) {
        List<RedisCommand<K, V, ?>> toCancel;
        Iterator<RedisCommand<K, V, ?>> iterator = this.stateLock;
        synchronized (iterator) {
            try {
                this.lockWritersExclusive();
                toCancel = this.prepareReset();
            }
            finally {
                this.unlockWritersExclusive();
            }
        }
        for (RedisCommand<K, V, ?> cmd : toCancel) {
            if (cmd.getOutput() != null) {
                cmd.getOutput().setError(message);
            }
            cmd.cancel();
        }
    }

    protected List<RedisCommand<K, V, ?>> prepareReset() {
        int size = 0;
        if (this.queue != null) {
            size += this.queue.size();
        }
        if (this.commandBuffer != null) {
            size += this.commandBuffer.size();
        }
        ArrayList toCancel = new ArrayList(size);
        if (this.queue != null) {
            toCancel.addAll(this.queue);
            this.queue.clear();
        }
        if (this.commandBuffer != null) {
            toCancel.addAll(this.commandBuffer);
            this.commandBuffer.clear();
        }
        return toCancel;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        InternalLogLevel logLevel = InternalLogLevel.WARN;
        if (!this.queue.isEmpty()) {
            RedisCommand<K, V, ?> command = this.queue.poll();
            if (this.debugEnabled) {
                logger.debug("{} Storing exception in {}", (Object)this.logPrefix(), (Object)command);
            }
            logLevel = InternalLogLevel.DEBUG;
            command.completeExceptionally(cause);
        }
        if (this.channel == null || !this.channel.isActive() || !this.isConnected()) {
            if (this.debugEnabled) {
                logger.debug("{} Storing exception in connectionError", (Object)this.logPrefix());
            }
            logLevel = InternalLogLevel.DEBUG;
            this.connectionError = cause;
        }
        if (cause instanceof IOException && logLevel.ordinal() > InternalLogLevel.INFO.ordinal()) {
            logLevel = InternalLogLevel.INFO;
            if (SUPPRESS_IO_EXCEPTION_MESSAGES.contains(cause.getMessage())) {
                logLevel = InternalLogLevel.DEBUG;
            }
        }
        logger.log(logLevel, "{} Unexpected exception during request: {}", this.logPrefix, cause.toString(), cause);
    }

    @Override
    public void close() {
        if (this.debugEnabled) {
            logger.debug("{} close()", (Object)this.logPrefix());
        }
        if (this.lifecycleState == LifecycleState.CLOSED) {
            return;
        }
        this.setStateIfNotClosed(LifecycleState.CLOSED);
        Channel currentChannel = this.channel;
        if (currentChannel != null) {
            currentChannel.pipeline().fireUserEventTriggered(new ConnectionEvents.PrepareClose());
            currentChannel.pipeline().fireUserEventTriggered(new ConnectionEvents.Close());
            ChannelFuture close = currentChannel.pipeline().close();
            if (currentChannel.isOpen()) {
                close.syncUninterruptibly();
            }
        } else if (this.connectionWatchdog != null) {
            this.connectionWatchdog.prepareClose(new ConnectionEvents.PrepareClose());
        }
    }

    public boolean isClosed() {
        return this.lifecycleState == LifecycleState.CLOSED;
    }

    @Override
    public void reset() {
        if (this.debugEnabled) {
            logger.debug("{} reset()", (Object)this.logPrefix());
        }
        this.cancelCommands("Reset");
        if (this.buffer != null) {
            this.rsm.reset();
            this.buffer.clear();
        }
    }

    public void initialState() {
        this.setState(LifecycleState.NOT_CONNECTED);
        this.queue.clear();
        this.commandBuffer.clear();
        Channel currentChannel = this.channel;
        if (currentChannel != null) {
            currentChannel.pipeline().fireUserEventTriggered(new ConnectionEvents.PrepareClose());
            currentChannel.pipeline().fireUserEventTriggered(new ConnectionEvents.Close());
            currentChannel.pipeline().close();
        }
    }

    @Override
    public void setRedisChannelHandler(RedisChannelHandler<K, V> redisChannelHandler) {
        this.redisChannelHandler = redisChannelHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        Object object = this.stateLock;
        synchronized (object) {
            this.autoFlushCommands = autoFlush;
        }
    }

    protected String logPrefix() {
        if (this.logPrefix != null) {
            return this.logPrefix;
        }
        StringBuffer buffer = new StringBuffer(64);
        buffer.append('[').append(ChannelLogDescriptor.logDescriptor(this.channel)).append(']');
        this.logPrefix = buffer.toString();
        return this.logPrefix;
    }

    private void releaseBuffer() {
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }

    private void releaseStateMachine() {
        if (this.rsm != null) {
            this.rsm.close();
            this.rsm = null;
        }
    }

    static class WriteLogListener
    implements GenericFutureListener<Future<Void>> {
        WriteLogListener() {
        }

        @Override
        public void operationComplete(Future<Void> future) throws Exception {
            Throwable cause = future.cause();
            if (!future.isSuccess() && !(cause instanceof ClosedChannelException)) {
                String message = "Unexpected exception during request: {}";
                InternalLogLevel logLevel = InternalLogLevel.WARN;
                if (cause instanceof IOException && SUPPRESS_IO_EXCEPTION_MESSAGES.contains(cause.getMessage())) {
                    logLevel = InternalLogLevel.DEBUG;
                }
                logger.log(logLevel, message, (Object)cause.toString(), (Object)cause);
            }
        }
    }

    private static class AtMostOnceWriteListener<K, V, T>
    implements ChannelFutureListener {
        private final Collection<RedisCommand<K, V, T>> sentCommands;
        private final Queue<?> queue;

        public AtMostOnceWriteListener(RedisCommand<K, V, T> sentCommand, Queue<?> queue) {
            this(LettuceLists.newList(sentCommand), queue);
        }

        public AtMostOnceWriteListener(Collection<RedisCommand<K, V, T>> sentCommand, Queue<?> queue) {
            this.sentCommands = sentCommand;
            this.queue = queue;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            future.await();
            if (future.cause() != null) {
                for (RedisCommand<K, V, T> sentCommand : this.sentCommands) {
                    sentCommand.completeExceptionally(future.cause());
                }
                this.queue.removeAll(this.sentCommands);
            }
        }
    }

    private static enum Reliability {
        AT_MOST_ONCE,
        AT_LEAST_ONCE;

    }

    public static enum LifecycleState {
        NOT_CONNECTED,
        REGISTERED,
        CONNECTED,
        ACTIVATING,
        ACTIVE,
        DISCONNECTED,
        DEACTIVATING,
        DEACTIVATED,
        CLOSED;

    }
}

