/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.io.netty.buffer.ByteBuf;
import com.lambdaworks.io.netty.buffer.UnpooledByteBufAllocator;
import com.lambdaworks.redis.codec.ByteArrayCodec;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.LettuceCharsets;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CommandArgs<K, V> {
    static final byte[] CRLF = "\r\n".getBytes(LettuceCharsets.ASCII);
    protected final RedisCodec<K, V> codec;
    private final List<SingularArgument> singularArguments = new ArrayList<SingularArgument>(10);
    private Long firstInteger;
    private String firstString;
    private ByteBuffer firstEncodedKey;
    private K firstKey;

    public CommandArgs(RedisCodec<K, V> codec) {
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
        this.codec = codec;
    }

    public int count() {
        return this.singularArguments.size();
    }

    public CommandArgs<K, V> addKey(K key) {
        if (this.firstKey == null) {
            this.firstKey = key;
        }
        this.singularArguments.add(KeyArgument.of(key, this.codec));
        return this;
    }

    public CommandArgs<K, V> addKeys(Iterable<K> keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        for (K key : keys) {
            this.addKey(key);
        }
        return this;
    }

    public CommandArgs<K, V> addKeys(K ... keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        for (K key : keys) {
            this.addKey(key);
        }
        return this;
    }

    public CommandArgs<K, V> addValue(V value) {
        this.singularArguments.add(ValueArgument.of(value, this.codec));
        return this;
    }

    public CommandArgs<K, V> addValues(Iterable<V> values) {
        LettuceAssert.notNull(values, "Values must not be null");
        for (V value : values) {
            this.addValue(value);
        }
        return this;
    }

    public CommandArgs<K, V> addValues(V ... values) {
        LettuceAssert.notNull(values, "Values must not be null");
        for (V value : values) {
            this.addValue(value);
        }
        return this;
    }

    public CommandArgs<K, V> add(Map<K, V> map) {
        LettuceAssert.notNull(map, "Map must not be null");
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.addKey(entry.getKey()).addValue(entry.getValue());
        }
        return this;
    }

    public CommandArgs<K, V> add(String s) {
        if (this.firstString == null) {
            this.firstString = s;
        }
        this.singularArguments.add(StringArgument.of(s));
        return this;
    }

    public CommandArgs<K, V> add(long n) {
        if (this.firstInteger == null) {
            this.firstInteger = n;
        }
        this.singularArguments.add(IntegerArgument.of(n));
        return this;
    }

    public CommandArgs<K, V> add(double n) {
        this.singularArguments.add(DoubleArgument.of(n));
        return this;
    }

    public CommandArgs<K, V> add(byte[] value) {
        this.singularArguments.add(BytesArgument.of(value));
        return this;
    }

    public CommandArgs<K, V> add(CommandKeyword keyword) {
        LettuceAssert.notNull(keyword, "CommandKeyword must not be null");
        return this.add(keyword.bytes);
    }

    public CommandArgs<K, V> add(CommandType type) {
        LettuceAssert.notNull(type, "CommandType must not be null");
        return this.add(type.bytes);
    }

    public CommandArgs<K, V> add(ProtocolKeyword keyword) {
        LettuceAssert.notNull(keyword, "CommandKeyword must not be null");
        return this.add(keyword.getBytes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        ByteBuf buffer = UnpooledByteBufAllocator.DEFAULT.buffer(this.singularArguments.size() * 10);
        this.encode(buffer);
        buffer.resetReaderIndex();
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        sb.append(" [buffer=").append(new String(bytes));
        sb.append(']');
        buffer.release();
        return sb.toString();
    }

    public Long getFirstInteger() {
        return this.firstInteger;
    }

    public String getFirstString() {
        return this.firstString;
    }

    public ByteBuffer getFirstEncodedKey() {
        if (this.firstKey == null) {
            return null;
        }
        if (this.firstEncodedKey == null) {
            this.firstEncodedKey = this.codec.encodeKey(this.firstKey);
        }
        return this.firstEncodedKey.duplicate();
    }

    public void encode(ByteBuf buf) {
        for (SingularArgument singularArgument : this.singularArguments) {
            singularArgument.encode(buf);
        }
    }

    public static final class ExperimentalByteArrayCodec
    extends ByteArrayCodec {
        public static final ExperimentalByteArrayCodec INSTANCE = new ExperimentalByteArrayCodec();

        private ExperimentalByteArrayCodec() {
        }

        public void encodeKey(ByteBuf target, byte[] key) {
            target.writeByte(36);
            if (key == null) {
                target.writeBytes("0\r\n\r\n".getBytes());
                return;
            }
            IntegerArgument.writeInteger(target, key.length);
            target.writeBytes(CRLF);
            target.writeBytes(key);
            target.writeBytes(CRLF);
        }

        public void encodeValue(ByteBuf target, byte[] value) {
            this.encodeKey(target, value);
        }
    }

    static class ValueArgument<K, V>
    extends SingularArgument {
        final V val;
        final RedisCodec<K, V> codec;

        private ValueArgument(V val, RedisCodec<K, V> codec) {
            this.val = val;
            this.codec = codec;
        }

        static <K, V> ValueArgument<K, V> of(V val, RedisCodec<K, V> codec) {
            return new ValueArgument<K, V>(val, codec);
        }

        @Override
        void encode(ByteBuf target) {
            if (this.codec == ExperimentalByteArrayCodec.INSTANCE) {
                ((ExperimentalByteArrayCodec)this.codec).encodeValue(target, (byte[])this.val);
                return;
            }
            ByteBufferArgument.writeByteBuffer(target, this.codec.encodeValue(this.val));
        }
    }

    static class KeyArgument<K, V>
    extends SingularArgument {
        final K key;
        final RedisCodec<K, V> codec;

        private KeyArgument(K key, RedisCodec<K, V> codec) {
            this.key = key;
            this.codec = codec;
        }

        static <K, V> KeyArgument<K, V> of(K key, RedisCodec<K, V> codec) {
            return new KeyArgument<K, V>(key, codec);
        }

        @Override
        void encode(ByteBuf target) {
            if (this.codec == ExperimentalByteArrayCodec.INSTANCE) {
                ((ExperimentalByteArrayCodec)this.codec).encodeKey(target, (byte[])this.key);
                return;
            }
            ByteBufferArgument.writeByteBuffer(target, this.codec.encodeKey(this.key));
        }
    }

    static class StringArgument
    extends SingularArgument {
        final String val;

        private StringArgument(String val) {
            this.val = val;
        }

        static StringArgument of(String val) {
            return new StringArgument(val);
        }

        @Override
        void encode(ByteBuf target) {
            StringArgument.writeString(target, this.val);
        }

        static void writeString(ByteBuf target, String value) {
            target.writeByte(36);
            IntegerArgument.writeInteger(target, value.length());
            target.writeBytes(CRLF);
            for (int i = 0; i < value.length(); ++i) {
                target.writeByte((byte)value.charAt(i));
            }
            target.writeBytes(CRLF);
        }
    }

    static class DoubleArgument
    extends SingularArgument {
        final double val;

        private DoubleArgument(double val) {
            this.val = val;
        }

        static DoubleArgument of(double val) {
            return new DoubleArgument(val);
        }

        @Override
        void encode(ByteBuf target) {
            StringArgument.writeString(target, Double.toString(this.val));
        }
    }

    static class IntegerCache {
        static final IntegerArgument[] cache;

        IntegerCache() {
        }

        static {
            int high = Integer.getInteger("biz.paluch.redis.CommandArgs.IntegerCache", 128);
            cache = new IntegerArgument[high];
            for (int i = 0; i < high; ++i) {
                IntegerCache.cache[i] = new IntegerArgument(i);
            }
        }
    }

    static class IntegerArgument
    extends SingularArgument {
        static IntegerCache integerCache = new IntegerCache();
        final long val;

        private IntegerArgument(long val) {
            this.val = val;
        }

        static IntegerArgument of(long val) {
            if (val >= 0L) {
                if (val < (long)IntegerCache.cache.length) {
                    return IntegerCache.cache[(int)val];
                }
            }
            return new IntegerArgument(val);
        }

        @Override
        void encode(ByteBuf target) {
            StringArgument.writeString(target, Long.toString(this.val));
        }

        static void writeInteger(ByteBuf target, long value) {
            if (value < 10L) {
                target.writeByte((byte)(48L + value));
                return;
            }
            String asString = Long.toString(value);
            for (int i = 0; i < asString.length(); ++i) {
                target.writeByte((byte)asString.charAt(i));
            }
        }
    }

    static class ByteBufferArgument {
        ByteBufferArgument() {
        }

        static void writeByteBuffer(ByteBuf target, ByteBuffer value) {
            target.writeByte(36);
            IntegerArgument.writeInteger(target, value.remaining());
            target.writeBytes(CRLF);
            target.writeBytes(value);
            target.writeBytes(CRLF);
        }
    }

    static class BytesArgument
    extends SingularArgument {
        final byte[] val;

        private BytesArgument(byte[] val) {
            this.val = val;
        }

        static BytesArgument of(byte[] val) {
            return new BytesArgument(val);
        }

        @Override
        void encode(ByteBuf buffer) {
            BytesArgument.writeBytes(buffer, this.val);
        }

        static void writeBytes(ByteBuf buffer, byte[] value) {
            buffer.writeByte(36);
            IntegerArgument.writeInteger(buffer, value.length);
            buffer.writeBytes(CRLF);
            buffer.writeBytes(value);
            buffer.writeBytes(CRLF);
        }
    }

    static abstract class SingularArgument {
        SingularArgument() {
        }

        abstract void encode(ByteBuf var1);
    }
}

