/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.io.netty.buffer.ByteBuf;
import com.lambdaworks.redis.RedisCommandExecutionException;
import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CompleteableCommand;
import com.lambdaworks.redis.protocol.DecoratedCommand;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class AsyncCommand<K, V, T>
extends CompletableFuture<T>
implements RedisCommand<K, V, T>,
RedisFuture<T>,
CompleteableCommand<T>,
DecoratedCommand<K, V, T> {
    protected RedisCommand<K, V, T> command;
    protected CountDownLatch latch = new CountDownLatch(1);

    public AsyncCommand(RedisCommand<K, V, T> command) {
        LettuceAssert.notNull(command, "RedisCommand must not be null");
        this.command = command;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) {
        try {
            return this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RedisCommandInterruptedException(e);
        }
    }

    @Override
    public CommandOutput<K, V, T> getOutput() {
        return this.command.getOutput();
    }

    @Override
    public void complete() {
        if (this.latch.getCount() == 1L) {
            this.completeResult();
            this.command.complete();
        }
        this.latch.countDown();
    }

    protected void completeResult() {
        if (this.command.getOutput() == null) {
            this.complete(null);
        } else if (this.command.getOutput().hasError()) {
            this.completeExceptionally(new RedisCommandExecutionException(this.command.getOutput().getError()));
        } else {
            this.complete(this.command.getOutput().get());
        }
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        boolean result = false;
        if (this.latch.getCount() == 1L) {
            this.command.completeExceptionally(ex);
            result = super.completeExceptionally(ex);
        }
        this.latch.countDown();
        return result;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.command.cancel();
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public String getError() {
        return this.command.getOutput().getError();
    }

    @Override
    public CommandArgs<K, V> getArgs() {
        return this.command.getArgs();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [type=").append(this.getType());
        sb.append(", output=").append(this.getOutput());
        sb.append(", commandType=").append(this.command.getClass().getName());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public ProtocolKeyword getType() {
        return this.command.getType();
    }

    @Override
    public void cancel() {
        this.cancel(true);
    }

    @Override
    public void encode(ByteBuf buf) {
        this.command.encode(buf);
    }

    @Override
    public void setOutput(CommandOutput<K, V, T> output) {
        this.command.setOutput(output);
    }

    @Override
    public void onComplete(Consumer<? super T> action) {
        this.thenAccept((Consumer)action);
    }

    @Override
    public RedisCommand<K, V, T> getDelegate() {
        return this.command;
    }
}

