/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.CommandOutput;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapOutput<K, V>
extends CommandOutput<K, V, Map<K, V>> {
    private K key;

    public MapOutput(RedisCodec<K, V> codec) {
        super(codec, new LinkedHashMap());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.key == null) {
            this.key = this.codec.decodeKey(bytes);
            return;
        }
        Object value = bytes == null ? null : (Object)this.codec.decodeValue(bytes);
        ((Map)this.output).put(this.key, value);
        this.key = null;
    }

    @Override
    public void set(long integer) {
        if (this.key == null) {
            this.key = integer;
            return;
        }
        Long value = integer;
        ((Map)this.output).put(this.key, value);
        this.key = null;
    }
}

