/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.models.role;

import com.lambdaworks.com.google.common.net.HostAndPort;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.RedisMasterInstance;
import com.lambdaworks.redis.models.role.RedisSentinelInstance;
import com.lambdaworks.redis.models.role.RedisSlaveInstance;
import com.lambdaworks.redis.models.role.ReplicationPartner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RoleParser {
    protected static final Map<String, RedisInstance.Role> ROLE_MAPPING;
    protected static final Map<String, RedisSlaveInstance.State> SLAVE_STATE_MAPPING;

    private RoleParser() {
    }

    public static RedisInstance parse(List<?> roleOutput) {
        LettuceAssert.isTrue(roleOutput != null && !roleOutput.isEmpty(), "Empty role output");
        LettuceAssert.isTrue(roleOutput.get(0) instanceof String && ROLE_MAPPING.containsKey(roleOutput.get(0)), "First role element must be a string (any of " + ROLE_MAPPING.keySet() + ")");
        RedisInstance.Role role = ROLE_MAPPING.get(roleOutput.get(0));
        switch (role) {
            case MASTER: {
                return RoleParser.parseMaster(roleOutput);
            }
            case SLAVE: {
                return RoleParser.parseSlave(roleOutput);
            }
            case SENTINEL: {
                return RoleParser.parseSentinel(roleOutput);
            }
        }
        return null;
    }

    private static RedisInstance parseMaster(List<?> roleOutput) {
        long replicationOffset = RoleParser.getMasterReplicationOffset(roleOutput);
        List<ReplicationPartner> slaves = RoleParser.getMasterSlaveReplicationPartners(roleOutput);
        RedisMasterInstance redisMasterInstanceRole = new RedisMasterInstance(replicationOffset, Collections.unmodifiableList(slaves));
        return redisMasterInstanceRole;
    }

    private static RedisInstance parseSlave(List<?> roleOutput) {
        Iterator<?> iterator = roleOutput.iterator();
        iterator.next();
        String ip = RoleParser.getStringFromIterator(iterator, "");
        long port = RoleParser.getLongFromIterator(iterator, 0L);
        String stateString = RoleParser.getStringFromIterator(iterator, null);
        long replicationOffset = RoleParser.getLongFromIterator(iterator, 0L);
        ReplicationPartner master = new ReplicationPartner(HostAndPort.fromParts(ip, Math.toIntExact(port)), replicationOffset);
        RedisSlaveInstance.State state = SLAVE_STATE_MAPPING.get(stateString);
        RedisSlaveInstance redisSlaveInstanceRole = new RedisSlaveInstance(master, state);
        return redisSlaveInstanceRole;
    }

    private static RedisInstance parseSentinel(List<?> roleOutput) {
        Iterator<?> iterator = roleOutput.iterator();
        iterator.next();
        List<String> monitoredMasters = RoleParser.getMonitoredMasters(iterator);
        RedisSentinelInstance result = new RedisSentinelInstance(Collections.unmodifiableList(monitoredMasters));
        return result;
    }

    private static List<String> getMonitoredMasters(Iterator<?> iterator) {
        ArrayList<String> monitoredMasters = new ArrayList<String>();
        if (!iterator.hasNext()) {
            return monitoredMasters;
        }
        Object masters = iterator.next();
        if (!(masters instanceof Collection)) {
            return monitoredMasters;
        }
        for (Object monitoredMaster : (Collection)masters) {
            if (!(monitoredMaster instanceof String)) continue;
            monitoredMasters.add((String)monitoredMaster);
        }
        return monitoredMasters;
    }

    private static List<ReplicationPartner> getMasterSlaveReplicationPartners(List<?> roleOutput) {
        ArrayList<ReplicationPartner> slaves = new ArrayList<ReplicationPartner>();
        if (roleOutput.size() > 2 && roleOutput.get(2) instanceof Collection) {
            Collection slavesOutput = (Collection)roleOutput.get(2);
            for (Object slaveOutput : slavesOutput) {
                if (!(slaveOutput instanceof Collection)) continue;
                ReplicationPartner replicationPartner = RoleParser.getMasterSlaveReplicationPartner((Collection)slaveOutput);
                slaves.add(replicationPartner);
            }
        }
        return slaves;
    }

    private static ReplicationPartner getMasterSlaveReplicationPartner(Collection<?> slaveOutput) {
        Iterator<?> iterator = slaveOutput.iterator();
        String ip = RoleParser.getStringFromIterator(iterator, "");
        long port = RoleParser.getLongFromIterator(iterator, 0L);
        long replicationOffset = RoleParser.getLongFromIterator(iterator, 0L);
        return new ReplicationPartner(HostAndPort.fromParts(ip, Math.toIntExact(port)), replicationOffset);
    }

    private static long getLongFromIterator(Iterator<?> iterator, long defaultValue) {
        if (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
        }
        return defaultValue;
    }

    private static String getStringFromIterator(Iterator<?> iterator, String defaultValue) {
        Object object;
        if (iterator.hasNext() && (object = iterator.next()) instanceof String) {
            return (String)object;
        }
        return defaultValue;
    }

    private static long getMasterReplicationOffset(List<?> roleOutput) {
        long replicationOffset = 0L;
        if (roleOutput.size() > 1 && roleOutput.get(1) instanceof Number) {
            Number number = (Number)roleOutput.get(1);
            replicationOffset = number.longValue();
        }
        return replicationOffset;
    }

    static {
        HashMap<String, RedisInstance.Role> roleMap = new HashMap<String, RedisInstance.Role>();
        roleMap.put("master", RedisInstance.Role.MASTER);
        roleMap.put("slave", RedisInstance.Role.SLAVE);
        roleMap.put("sentinel", RedisInstance.Role.SENTINEL);
        ROLE_MAPPING = Collections.unmodifiableMap(roleMap);
        HashMap<String, RedisSlaveInstance.State> slaveStateMap = new HashMap<String, RedisSlaveInstance.State>();
        slaveStateMap.put("connect", RedisSlaveInstance.State.CONNECT);
        slaveStateMap.put("connected", RedisSlaveInstance.State.CONNECTED);
        slaveStateMap.put("connecting", RedisSlaveInstance.State.CONNECTING);
        slaveStateMap.put("sync", RedisSlaveInstance.State.SYNC);
        SLAVE_STATE_MAPPING = Collections.unmodifiableMap(slaveStateMap);
    }
}

