/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.metrics;

import com.lambdaworks.io.netty.channel.local.LocalAddress;
import com.lambdaworks.io.netty.util.internal.logging.InternalLogger;
import com.lambdaworks.io.netty.util.internal.logging.InternalLoggerFactory;
import com.lambdaworks.org.HdrHistogram.Histogram;
import com.lambdaworks.org.LatencyUtils.LatencyStats;
import com.lambdaworks.org.LatencyUtils.PauseDetector;
import com.lambdaworks.org.LatencyUtils.SimplePauseDetector;
import com.lambdaworks.redis.internal.LettuceClassUtils;
import com.lambdaworks.redis.metrics.CommandLatencyCollector;
import com.lambdaworks.redis.metrics.CommandLatencyCollectorOptions;
import com.lambdaworks.redis.metrics.CommandLatencyId;
import com.lambdaworks.redis.metrics.CommandMetrics;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultCommandLatencyCollector
implements CommandLatencyCollector {
    private static final AtomicReference<PauseDetectorWrapper> PAUSE_DETECTOR = new AtomicReference();
    private static final boolean LATENCY_UTILS_AVAILABLE = LettuceClassUtils.isPresent("com.lambdaworks.org.LatencyUtils.PauseDetector");
    private static final boolean HDR_UTILS_AVAILABLE = LettuceClassUtils.isPresent("com.lambdaworks.org.HdrHistogram.Histogram");
    private static final long MIN_LATENCY = 1000L;
    private static final long MAX_LATENCY = TimeUnit.MINUTES.toNanos(5L);
    private final CommandLatencyCollectorOptions options;
    private Map<CommandLatencyId, Latencies> latencyMetrics = new ConcurrentHashMap<CommandLatencyId, Latencies>();

    public DefaultCommandLatencyCollector(CommandLatencyCollectorOptions options) {
        this.options = options;
    }

    @Override
    public void recordCommandLatency(SocketAddress local, SocketAddress remote, ProtocolKeyword commandType, long firstResponseLatency, long completionLatency) {
        if (!this.isEnabled()) {
            return;
        }
        CommandLatencyId id = this.createId(local, remote, commandType);
        Latencies latencies = this.latencyMetrics.get(id);
        if (latencies == null) {
            PauseDetectorWrapper wrapper = PAUSE_DETECTOR.get();
            if (wrapper == null && PAUSE_DETECTOR.compareAndSet(null, wrapper = new PauseDetectorWrapper())) {
                wrapper.initialize();
            }
            latencies = new Latencies(DefaultCommandLatencyCollector.PAUSE_DETECTOR.get().pauseDetector);
            this.latencyMetrics.put(id, latencies);
        }
        latencies.firstResponse.recordLatency(this.rangify(firstResponseLatency));
        latencies.completion.recordLatency(this.rangify(completionLatency));
    }

    private CommandLatencyId createId(SocketAddress local, SocketAddress remote, ProtocolKeyword commandType) {
        return CommandLatencyId.create(this.options.localDistinction() ? local : LocalAddress.ANY, remote, commandType);
    }

    private long rangify(long latency) {
        return Math.max(1000L, Math.min(MAX_LATENCY, latency));
    }

    @Override
    public boolean isEnabled() {
        return this.latencyMetrics != null && this.options.isEnabled();
    }

    @Override
    public void shutdown() {
        if (this.latencyMetrics != null) {
            this.latencyMetrics.clear();
            this.latencyMetrics = null;
        }
    }

    @Override
    public Map<CommandLatencyId, CommandMetrics> retrieveMetrics() {
        HashMap<CommandLatencyId, Latencies> copy = new HashMap<CommandLatencyId, Latencies>();
        copy.putAll(this.latencyMetrics);
        if (this.options.resetLatenciesAfterEvent()) {
            this.latencyMetrics.clear();
        }
        Map<CommandLatencyId, CommandMetrics> latencies = this.getMetrics(copy);
        return latencies;
    }

    private Map<CommandLatencyId, CommandMetrics> getMetrics(Map<CommandLatencyId, Latencies> latencyMetrics) {
        TreeMap<CommandLatencyId, CommandMetrics> latencies = new TreeMap<CommandLatencyId, CommandMetrics>();
        for (Map.Entry<CommandLatencyId, Latencies> entry : latencyMetrics.entrySet()) {
            Histogram firstResponse = entry.getValue().firstResponse.getIntervalHistogram();
            Histogram completion = entry.getValue().completion.getIntervalHistogram();
            if (firstResponse.getTotalCount() == 0L && completion.getTotalCount() == 0L) continue;
            CommandMetrics.CommandLatency firstResponseLatency = this.getMetric(firstResponse);
            CommandMetrics.CommandLatency completionLatency = this.getMetric(completion);
            CommandMetrics metrics = new CommandMetrics(firstResponse.getTotalCount(), this.options.targetUnit(), firstResponseLatency, completionLatency);
            latencies.put(entry.getKey(), metrics);
        }
        return latencies;
    }

    private CommandMetrics.CommandLatency getMetric(Histogram histogram) {
        Map<Double, Long> percentiles = this.getPercentiles(histogram);
        TimeUnit timeUnit = this.options.targetUnit();
        CommandMetrics.CommandLatency metric = new CommandMetrics.CommandLatency(timeUnit.convert(histogram.getMinValue(), TimeUnit.NANOSECONDS), timeUnit.convert(histogram.getMaxValue(), TimeUnit.NANOSECONDS), percentiles);
        return metric;
    }

    private Map<Double, Long> getPercentiles(Histogram histogram) {
        TreeMap<Double, Long> percentiles = new TreeMap<Double, Long>();
        for (double targetPercentile : this.options.targetPercentiles()) {
            percentiles.put(targetPercentile, this.options.targetUnit().convert(histogram.getValueAtPercentile(targetPercentile), TimeUnit.NANOSECONDS));
        }
        return percentiles;
    }

    public static boolean isAvailable() {
        return LATENCY_UTILS_AVAILABLE && HDR_UTILS_AVAILABLE;
    }

    public static CommandLatencyCollector disabled() {
        return new CommandLatencyCollector(){

            @Override
            public void recordCommandLatency(SocketAddress local, SocketAddress remote, ProtocolKeyword commandType, long firstResponseLatency, long completionLatency) {
            }

            @Override
            public void shutdown() {
            }

            @Override
            public Map<CommandLatencyId, CommandMetrics> retrieveMetrics() {
                return Collections.emptyMap();
            }

            @Override
            public boolean isEnabled() {
                return false;
            }
        };
    }

    private static class PauseDetectorWrapper {
        public static final AtomicLong counter = new AtomicLong();
        PauseDetector pauseDetector;

        private PauseDetectorWrapper() {
        }

        public void initialize() {
            if (counter.getAndIncrement() > 0L) {
                InternalLogger instance = InternalLoggerFactory.getInstance(this.getClass());
                instance.info("Initialized PauseDetectorWrapper more than once.");
            }
            this.pauseDetector = new SimplePauseDetector(TimeUnit.MILLISECONDS.toNanos(10L), TimeUnit.MILLISECONDS.toNanos(10L), 3);
            Runtime.getRuntime().addShutdownHook(new Thread("ShutdownHook for SimplePauseDetector"){

                @Override
                public void run() {
                    pauseDetector.shutdown();
                }
            });
        }
    }

    private static class Latencies {
        public final LatencyStats firstResponse;
        public final LatencyStats completion;

        public Latencies(PauseDetector pauseDetector) {
            this.firstResponse = LatencyStats.Builder.create().pauseDetector(pauseDetector).build();
            this.completion = LatencyStats.Builder.create().pauseDetector(pauseDetector).build();
        }
    }
}

