/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.masterslave;

import com.lambdaworks.io.netty.util.internal.logging.InternalLogger;
import com.lambdaworks.io.netty.util.internal.logging.InternalLoggerFactory;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.masterslave.RedisMasterSlaveNode;
import com.lambdaworks.redis.masterslave.TopologyProvider;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MasterSlaveTopologyProvider
implements TopologyProvider {
    public static final Pattern ROLE_PATTERN = Pattern.compile("^role\\:([a-z]+)$", 8);
    public static final Pattern SLAVE_PATTERN = Pattern.compile("^slave(\\d+)\\:([a-zA-Z\\,\\=\\d\\.]+)$", 8);
    public static final Pattern MASTER_HOST_PATTERN = Pattern.compile("^master_host\\:([a-zA-Z\\,\\=\\d\\.]+)$", 8);
    public static final Pattern MASTER_PORT_PATTERN = Pattern.compile("^master_port\\:(\\d+)$", 8);
    public static final Pattern IP_PATTERN = Pattern.compile("ip\\=([a-z\\d\\.]+)");
    public static final Pattern PORT_PATTERN = Pattern.compile("port\\=([\\d]+)");
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MasterSlaveTopologyProvider.class);
    private final StatefulRedisConnection<?, ?> connection;
    private final RedisURI redisURI;

    public MasterSlaveTopologyProvider(StatefulRedisConnection<?, ?> connection, RedisURI redisURI) {
        LettuceAssert.notNull(connection, "Redis Connection must not be null");
        LettuceAssert.notNull(redisURI, "RedisURI must not be null");
        this.connection = connection;
        this.redisURI = redisURI;
    }

    @Override
    public List<RedisNodeDescription> getNodes() {
        logger.debug("Performing topology lookup");
        String info = this.connection.sync().info("replication");
        try {
            return this.getNodesFromInfo(info);
        }
        catch (RuntimeException e) {
            throw new RedisException(e);
        }
    }

    protected List<RedisNodeDescription> getNodesFromInfo(String info) {
        ArrayList<RedisNodeDescription> result = new ArrayList<RedisNodeDescription>();
        RedisNodeDescription currentNodeDescription = this.getCurrentNodeDescription(info);
        result.add(currentNodeDescription);
        if (currentNodeDescription.getRole() == RedisInstance.Role.MASTER) {
            result.addAll(this.getSlavesFromInfo(info));
        } else {
            result.add(this.getMasterFromInfo(info));
        }
        return result;
    }

    private RedisNodeDescription getCurrentNodeDescription(String info) {
        Matcher matcher = ROLE_PATTERN.matcher(info);
        if (!matcher.find()) {
            throw new IllegalStateException("No role property in info " + info);
        }
        return this.getRedisNodeDescription(matcher);
    }

    private List<RedisNodeDescription> getSlavesFromInfo(String info) {
        ArrayList<RedisNodeDescription> slaves = new ArrayList<RedisNodeDescription>();
        Matcher matcher = SLAVE_PATTERN.matcher(info);
        while (matcher.find()) {
            String group = matcher.group(2);
            String ip = this.getNested(IP_PATTERN, group, 1);
            String port = this.getNested(PORT_PATTERN, group, 1);
            slaves.add(new RedisMasterSlaveNode(ip, Integer.parseInt(port), this.redisURI, RedisInstance.Role.SLAVE));
        }
        return slaves;
    }

    private RedisNodeDescription getMasterFromInfo(String info) {
        Matcher masterHostMatcher = MASTER_HOST_PATTERN.matcher(info);
        Matcher masterPortMatcher = MASTER_PORT_PATTERN.matcher(info);
        boolean foundHost = masterHostMatcher.find();
        boolean foundPort = masterPortMatcher.find();
        if (!foundHost || !foundPort) {
            throw new IllegalStateException("Cannot resolve master from info " + info);
        }
        String host = masterHostMatcher.group(1);
        int port = Integer.parseInt(masterPortMatcher.group(1));
        return new RedisMasterSlaveNode(host, port, this.redisURI, RedisInstance.Role.MASTER);
    }

    private String getNested(Pattern pattern, String string, int group) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(group);
        }
        throw new IllegalArgumentException("Cannot extract group " + group + " with pattern " + pattern + " from " + string);
    }

    private RedisNodeDescription getRedisNodeDescription(Matcher matcher) {
        String roleString = matcher.group(1);
        RedisInstance.Role role = null;
        if (RedisInstance.Role.MASTER.name().equalsIgnoreCase(roleString)) {
            role = RedisInstance.Role.MASTER;
        }
        if (RedisInstance.Role.SLAVE.name().equalsIgnoreCase(roleString)) {
            role = RedisInstance.Role.SLAVE;
        }
        if (role == null) {
            throw new IllegalStateException("Cannot resolve role " + roleString + " to " + (Object)((Object)RedisInstance.Role.MASTER) + " or " + (Object)((Object)RedisInstance.Role.SLAVE));
        }
        return new RedisMasterSlaveNode(this.redisURI.getHost(), this.redisURI.getPort(), this.redisURI, role);
    }
}

