/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.event.metrics;

import com.lambdaworks.io.netty.util.concurrent.EventExecutorGroup;
import com.lambdaworks.io.netty.util.concurrent.ScheduledFuture;
import com.lambdaworks.redis.event.EventBus;
import com.lambdaworks.redis.event.EventPublisherOptions;
import com.lambdaworks.redis.event.metrics.CommandLatencyEvent;
import com.lambdaworks.redis.event.metrics.MetricEventPublisher;
import com.lambdaworks.redis.metrics.CommandLatencyCollector;
import java.util.Map;

public class DefaultCommandLatencyEventPublisher
implements MetricEventPublisher {
    private final EventExecutorGroup eventExecutorGroup;
    private final EventPublisherOptions options;
    private final EventBus eventBus;
    private final CommandLatencyCollector commandLatencyCollector;
    private final Runnable EMITTER = new Runnable(){

        @Override
        public void run() {
            DefaultCommandLatencyEventPublisher.this.emitMetricsEvent();
        }
    };
    private volatile ScheduledFuture<?> scheduledFuture;

    public DefaultCommandLatencyEventPublisher(EventExecutorGroup eventExecutorGroup, EventPublisherOptions options, EventBus eventBus, CommandLatencyCollector commandLatencyCollector) {
        this.eventExecutorGroup = eventExecutorGroup;
        this.options = options;
        this.eventBus = eventBus;
        this.commandLatencyCollector = commandLatencyCollector;
        if (options.eventEmitInterval() > 0L) {
            this.scheduledFuture = this.eventExecutorGroup.scheduleAtFixedRate(this.EMITTER, options.eventEmitInterval(), options.eventEmitInterval(), options.eventEmitIntervalUnit());
        }
    }

    @Override
    public boolean isEnabled() {
        return this.options.eventEmitInterval() > 0L && this.scheduledFuture != null;
    }

    @Override
    public void shutdown() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    @Override
    public void emitMetricsEvent() {
        if (!this.isEnabled() || !this.commandLatencyCollector.isEnabled()) {
            return;
        }
        this.eventBus.publish(new CommandLatencyEvent((Map)this.commandLatencyCollector.retrieveMetrics()));
    }
}

